/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.AbstractSweepParameterSetter;
import repast.simphony.parameter.Parameters;

public class ListParameterSetter<T>
extends AbstractSweepParameterSetter<T> {
    private T[] list;
    private int index;
    private int revertIndex;

    public ListParameterSetter(String parameterName, T[] list) {
        super(parameterName);
        this.list = list;
        this.index = 0;
        this.revertIndex = 0;
    }

    @Override
    public void reset(Parameters params) {
        this.revertIndex = this.index;
        this.index = 1;
        params.setValue(this.parameterName, this.list[0]);
    }

    @Override
    public boolean atEnd() {
        return this.index == this.list.length;
    }

    @Override
    protected T nextValue(T prevValue) {
        this.revertIndex = this.index++;
        return this.list[this.index - 1];
    }

    @Override
    public void revert(Parameters params) {
        if (this.revertIndex == this.list.length) {
            params.setValue(this.parameterName, this.list[this.list.length - 1]);
        } else {
            params.setValue(this.parameterName, this.list[this.revertIndex]);
        }
        this.index = this.revertIndex;
    }

    @Override
    public boolean atBeginning() {
        return this.index == 0;
    }

    @Override
    protected T previousValue(T prevValue) {
        if (this.atEnd()) {
            this.revertIndex = this.list.length;
            this.index = this.list.length - 1;
        } else {
            this.revertIndex = this.index--;
        }
        return this.list[this.index];
    }

    @Override
    protected T randomValue() {
        this.revertIndex = this.index;
        this.index = this.randInt(0, this.list.length - 1);
        return this.list[this.index];
    }

    @Override
    protected T resetValue() {
        throw new UnsupportedOperationException("resetValue unsupported");
    }

    @Override
    protected boolean atEnd(T prevValue) {
        throw new UnsupportedOperationException("atEnd unsupported");
    }

    @Override
    protected boolean atBeginning(T prevValue) {
        throw new UnsupportedOperationException("atBeginning unsupported");
    }

    public String toString() {
        return "[list " + this.parameterName + this.list + "]";
    }
}

