/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import junit.framework.TestCase;
import repast.simphony.parameter.ListParameterSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;

public class ListInitializerTest
extends TestCase {
    private ListParameterSetter<String> initializer;
    private String[] list;
    private Parameters params;

    protected void setUp() throws Exception {
        this.list = new String[]{"s0", "s1", "s2", "s3"};
        this.initializer = new ListParameterSetter<String>("paramName", this.list);
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("paramName", String.class, (Object)"s0", false);
        this.params = creator.createParameters();
    }

    public void testForwards() {
        ListInitializerTest.assertTrue((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[0], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[1], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[2], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertTrue((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[3], (Object)this.params.getValue("paramName"));
    }

    public void testMixed() {
        ListInitializerTest.assertTrue((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[0], (Object)this.params.getValue("paramName"));
        this.initializer.previous(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertTrue((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[0], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[0], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[1], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[2], (Object)this.params.getValue("paramName"));
        this.initializer.next(this.params);
        ListInitializerTest.assertTrue((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[3], (Object)this.params.getValue("paramName"));
        this.initializer.previous(this.params);
        ListInitializerTest.assertFalse((boolean)this.initializer.atEnd());
        ListInitializerTest.assertFalse((boolean)this.initializer.atBeginning());
        ListInitializerTest.assertEquals((Object)this.list[3], (Object)this.params.getValue("paramName"));
    }
}

