/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import junit.framework.TestCase;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;

public class IntSteppedTest
extends TestCase {
    IntSteppedSetter init;
    private Parameters params;

    protected void setUp() throws Exception {
        this.init = new IntSteppedSetter("x", 0, 10, 1);
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("x", Integer.class, (Object)0, false);
        this.params = creator.createParameters();
    }

    public void testForwards(boolean ignoreBeginningTest) {
        IntSteppedTest.assertTrue((ignoreBeginningTest || this.init.atBeginning() ? 1 : 0) != 0);
        this.init.reset(this.params);
        IntSteppedTest.assertEquals((Object)0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 10) {
            this.init.next(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            IntSteppedTest.assertFalse((boolean)this.init.atBeginning());
            ++i;
        }
        IntSteppedTest.assertTrue((boolean)this.init.atEnd());
    }

    public void testForwardsThenBackwards() {
        this.testForwards();
        IntSteppedTest.assertFalse((boolean)this.init.atBeginning());
        int i = 9;
        while (i > 0) {
            this.init.previous(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            IntSteppedTest.assertFalse((boolean)this.init.atBeginning());
            --i;
        }
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)0, (Object)this.params.getValue("x"));
        IntSteppedTest.assertTrue((boolean)this.init.atBeginning());
    }

    public void testForwards() {
        this.testForwards(false);
        this.testForwards(true);
    }

    public void testForwardRevert() {
        IntSteppedTest.assertTrue((boolean)this.init.atBeginning());
        this.init.reset(this.params);
        IntSteppedTest.assertEquals((Object)0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 10) {
            this.init.next(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            this.init.revert(this.params);
            IntSteppedTest.assertEquals((Object)(i - 1), (Object)this.params.getValue("x"));
            this.init.next(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            ++i;
        }
        IntSteppedTest.assertTrue((boolean)this.init.atEnd());
    }

    public void testMixedWithRevert() {
        IntSteppedTest.assertTrue((boolean)this.init.atBeginning());
        this.init.reset(this.params);
        IntSteppedTest.assertEquals((Object)0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 5) {
            this.init.next(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            this.init.revert(this.params);
            IntSteppedTest.assertEquals((Object)(i - 1), (Object)this.params.getValue("x"));
            this.init.next(this.params);
            IntSteppedTest.assertEquals((Object)i, (Object)this.params.getValue("x"));
            ++i;
        }
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)4, (Object)this.params.getValue("x"));
        this.init.revert(this.params);
        IntSteppedTest.assertEquals((Object)5, (Object)this.params.getValue("x"));
        this.init.next(this.params);
        IntSteppedTest.assertEquals((Object)6, (Object)this.params.getValue("x"));
        this.init.revert(this.params);
        IntSteppedTest.assertEquals((Object)5, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)4, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)3, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)2, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)1, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        IntSteppedTest.assertEquals((Object)0, (Object)this.params.getValue("x"));
        IntSteppedTest.assertTrue((boolean)this.init.atBeginning());
        IntSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.revert(this.params);
        IntSteppedTest.assertEquals((Object)1, (Object)this.params.getValue("x"));
    }
}

