/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.AbstractSweepParameterSetter;

public class IntSteppedSetter
extends AbstractSweepParameterSetter<Integer> {
    private int stepSize;
    private int max;
    private int base;

    public IntSteppedSetter(String parameterName, int base, int max, int step) {
        super(parameterName);
        this.base = base;
        this.stepSize = step;
        this.max = max;
    }

    @Override
    public Integer resetValue() {
        return this.base;
    }

    @Override
    public boolean atEnd(Integer prevValue) {
        if (prevValue == null) {
            return false;
        }
        return prevValue + this.stepSize > this.max;
    }

    @Override
    public boolean atBeginning(Integer prevValue) {
        if (prevValue == null) {
            return true;
        }
        return prevValue - this.stepSize < this.base;
    }

    @Override
    protected Integer nextValue(Integer prevValue) {
        if (prevValue == null) {
            prevValue = this.base;
        }
        return prevValue + this.stepSize;
    }

    @Override
    protected Integer randomValue() {
        int numSteps = (int)Math.floor((this.max - this.base) / this.stepSize);
        int steps = this.randInt(0, numSteps);
        return steps * this.stepSize + this.base;
    }

    @Override
    protected Integer previousValue(Integer prevValue) {
        if (prevValue == null) {
            prevValue = this.base + this.stepSize;
        }
        return prevValue - this.stepSize;
    }

    public String toString() {
        return "[int " + this.parameterName + " " + this.base + ".." + this.max + "," + this.stepSize + "]";
    }
}

