/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import java.math.BigDecimal;
import repast.simphony.parameter.IntSteppedSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.optimizer.OptimizableParameterSetter;

public class FloatSteppedSetter
implements OptimizableParameterSetter {
    private BigDecimal stepSize;
    private BigDecimal base;
    private float max;
    private IntSteppedSetter initializer;
    private Parameters intInitParams;
    private String parameterName;

    public FloatSteppedSetter(String parameterName, float base, float max, float step) {
        this.parameterName = parameterName;
        this.base = BigDecimal.valueOf(base);
        this.stepSize = BigDecimal.valueOf(step);
        this.max = max;
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("step", Integer.class, (Object)0, false);
        this.intInitParams = creator.createParameters();
        this.initializer = new IntSteppedSetter("step", 0, (int)Math.rint((max - base) / step), 1);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void next(Parameters params) {
        this.initializer.next(this.intInitParams);
        params.setValue(this.parameterName, (Object)Float.valueOf(this.getValue()));
    }

    protected float getValue() {
        return this.stepSize.multiply(new BigDecimal(this.getStep())).add(this.base).floatValue();
    }

    public int getStep() {
        return (Integer)this.intInitParams.getValue("step");
    }

    @Override
    public void previous(Parameters parameters) {
        this.initializer.previous(this.intInitParams);
        parameters.setValue(this.parameterName, (Object)Float.valueOf(this.getValue()));
    }

    @Override
    public void random(Parameters parameters) {
        this.initializer.random(this.intInitParams);
        parameters.setValue(this.parameterName, (Object)Float.valueOf(this.getValue()));
    }

    @Override
    public boolean atBeginning() {
        return this.initializer.atBeginning();
    }

    public boolean atEnd() {
        return this.initializer.atEnd();
    }

    public String toString() {
        return "[float " + this.parameterName + " " + this.base + ".." + this.max + "," + this.stepSize + "]";
    }

    @Override
    public void revert(Parameters parameters) {
        this.initializer.revert(this.intInitParams);
        parameters.setValue(this.parameterName, (Object)Float.valueOf(this.getValue()));
    }

    public void reset(Parameters params) {
        this.initializer.reset(this.intInitParams);
        params.setValue(this.parameterName, (Object)Float.valueOf(this.getValue()));
    }
}

