/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import junit.framework.TestCase;
import repast.simphony.parameter.DoubleSteppedSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;

public class DoubleSteppedTest
extends TestCase {
    DoubleSteppedSetter init;
    private Parameters params;

    protected void setUp() throws Exception {
        this.init = new DoubleSteppedSetter("x", 0.0, 10.0, 1.0);
        ParametersCreator creator = new ParametersCreator();
        creator.addParameter("x", Double.class, (Object)0, false);
        this.params = creator.createParameters();
    }

    public void testForwards(boolean ignoreBeginningTest) {
        DoubleSteppedTest.assertTrue((ignoreBeginningTest || this.init.atBeginning() ? 1 : 0) != 0);
        this.init.reset(this.params);
        DoubleSteppedTest.assertEquals((Object)0.0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 10) {
            this.init.next(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            DoubleSteppedTest.assertFalse((boolean)this.init.atBeginning());
            ++i;
        }
        DoubleSteppedTest.assertTrue((boolean)this.init.atEnd());
    }

    public void testForwardsThenBackwards() {
        this.testForwards();
        DoubleSteppedTest.assertFalse((boolean)this.init.atBeginning());
        int i = 9;
        while (i > 0) {
            this.init.previous(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            DoubleSteppedTest.assertFalse((boolean)this.init.atBeginning());
            --i;
        }
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)0.0, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertTrue((boolean)this.init.atBeginning());
    }

    public void testForwards() {
        this.testForwards(false);
        this.testForwards(true);
    }

    public void testForwardRevert() {
        DoubleSteppedTest.assertTrue((boolean)this.init.atBeginning());
        this.init.reset(this.params);
        DoubleSteppedTest.assertEquals((Object)0.0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 10) {
            this.init.next(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            this.init.revert(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i - 1), (Object)this.params.getValue("x"));
            this.init.next(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            ++i;
        }
        DoubleSteppedTest.assertTrue((boolean)this.init.atEnd());
    }

    public void testMixedWithRevert() {
        DoubleSteppedTest.assertTrue((boolean)this.init.atBeginning());
        this.init.reset(this.params);
        DoubleSteppedTest.assertEquals((Object)0.0, (Object)this.params.getValue("x"));
        int i = 1;
        while (i <= 5) {
            this.init.next(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            this.init.revert(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i - 1), (Object)this.params.getValue("x"));
            this.init.next(this.params);
            DoubleSteppedTest.assertEquals((Object)new Double(i), (Object)this.params.getValue("x"));
            ++i;
        }
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)4.0, (Object)this.params.getValue("x"));
        this.init.revert(this.params);
        DoubleSteppedTest.assertEquals((Object)5.0, (Object)this.params.getValue("x"));
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((Object)6.0, (Object)this.params.getValue("x"));
        this.init.revert(this.params);
        DoubleSteppedTest.assertEquals((Object)5.0, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)4.0, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)3.0, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)2.0, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)1.0, (Object)this.params.getValue("x"));
        this.init.previous(this.params);
        DoubleSteppedTest.assertEquals((Object)0.0, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertTrue((boolean)this.init.atBeginning());
        DoubleSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.revert(this.params);
        DoubleSteppedTest.assertEquals((Object)1.0, (Object)this.params.getValue("x"));
    }

    public void testPrecise() {
        this.init = new DoubleSteppedSetter("x", -1.0, 1.0, 0.3333333333333333);
        this.init.reset(this.params);
        DoubleSteppedTest.assertEquals((double)-1.0, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)-0.6666666666666666, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)-0.3333333333333333, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)0.0, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)0.3333333333333333, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)0.6666666666666666, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((double)1.0, (double)((Double)this.params.getValue("x")), (double)1.0E-7);
        DoubleSteppedTest.assertTrue((boolean)this.init.atEnd());
        this.init = new DoubleSteppedSetter("x", 0.8, 1.0, 0.05);
        System.out.println(0.8);
        this.init.reset(this.params);
        DoubleSteppedTest.assertEquals((Object)0.8, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.next(this.params);
        System.out.println(this.params.getValue("x"));
        DoubleSteppedTest.assertEquals((Object)0.85, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((Object)0.9, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((Object)0.95, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertFalse((boolean)this.init.atEnd());
        this.init.next(this.params);
        DoubleSteppedTest.assertEquals((Object)1.0, (Object)this.params.getValue("x"));
        DoubleSteppedTest.assertTrue((boolean)this.init.atEnd());
    }
}

