/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.AbstractSweepParameterSetter;

public class ByteSteppedSetter
extends AbstractSweepParameterSetter<Byte> {
    private byte stepSize;
    private byte max;
    private byte base;

    public ByteSteppedSetter(String parameterName, byte base, byte max, byte step) {
        super(parameterName);
        this.base = base;
        this.stepSize = step;
        this.max = max;
    }

    @Override
    public Byte resetValue() {
        return this.base;
    }

    @Override
    public boolean atEnd(Byte prevValue) {
        if (prevValue == null) {
            return false;
        }
        return prevValue + this.stepSize > this.max;
    }

    @Override
    public boolean atBeginning(Byte prevValue) {
        if (prevValue == null) {
            return true;
        }
        return prevValue - this.stepSize < this.base;
    }

    @Override
    protected Byte nextValue(Byte prevValue) {
        if (prevValue == null) {
            prevValue = this.base;
        }
        return (byte)(prevValue + this.stepSize);
    }

    @Override
    protected Byte randomValue() {
        int numSteps = (int)Math.floor((this.max - this.base) / this.stepSize);
        int steps = this.randInt(0, numSteps);
        return (byte)(steps * this.stepSize + this.base);
    }

    @Override
    protected Byte previousValue(Byte prevValue) {
        if (prevValue == null) {
            prevValue = (byte)(this.base + this.stepSize);
        }
        return (byte)(prevValue - this.stepSize);
    }

    public String toString() {
        return "[byte " + this.parameterName + " " + this.base + ".." + this.max + "," + this.stepSize + "]";
    }
}

