/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.parameter;

import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.optimizer.OptimizableParameterSetter;
import repast.simphony.random.RandomHelper;

public abstract class AbstractSweepParameterSetter<T>
implements OptimizableParameterSetter {
    public static final int RESET_INDEX = 0;
    public static final int LAST_VALUE_INDEX = 1;
    protected String parameterName;
    protected T lastValue;
    protected T revertValue;

    public AbstractSweepParameterSetter(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void next(Parameters params) {
        if (!this.atEnd()) {
            this.revertValue = this.lastValue;
            this.lastValue = this.nextValue(this.lastValue);
        }
        params.setValue(this.parameterName, this.lastValue);
    }

    @Override
    public void previous(Parameters parameters) {
        this.revertValue = this.lastValue;
        this.lastValue = this.previousValue(this.lastValue);
        parameters.setValue(this.parameterName, this.lastValue);
    }

    @Override
    public void random(Parameters parameters) {
        this.revertValue = this.lastValue;
        this.lastValue = this.randomValue();
        parameters.setValue(this.parameterName, this.lastValue);
    }

    protected abstract T nextValue(T var1);

    protected abstract T randomValue();

    protected abstract T previousValue(T var1);

    protected abstract T resetValue();

    protected abstract boolean atEnd(T var1);

    protected abstract boolean atBeginning(T var1);

    @Override
    public boolean atBeginning() {
        return this.atBeginning(this.lastValue);
    }

    public boolean atEnd() {
        return this.atEnd(this.lastValue);
    }

    public void reset(Parameters params) {
        this.revertValue = this.lastValue;
        this.lastValue = this.resetValue();
        params.setValue(this.parameterName, this.lastValue);
    }

    protected double randDouble(double from, double to) {
        return RandomHelper.getUniform().nextDoubleFromTo(from, to);
    }

    protected int randInt(int from, int to) {
        return RandomHelper.getUniform().nextIntFromTo(from, to);
    }

    @Override
    public void revert(Parameters params) {
        this.lastValue = this.revertValue;
        params.setValue(this.parameterName, this.revertValue);
    }
}

