/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import repast.simphony.engine.controller.TickListener;
import repast.simphony.engine.environment.AbstractRunner;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.ISchedule;
import simphony.util.messages.MessageCenter;

public class InteractivBatchRunner
extends AbstractRunner {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(InteractivBatchRunner.class);
    private TickListener tickListener = null;
    private Object monitor = new Object();
    private boolean step = false;

    public void execute(RunState toExecuteOn) {
        ISchedule schedule = this.getSchedule(toExecuteOn);
        ScheduleLoopRunnable runnable = new ScheduleLoopRunnable(schedule);
        Thread thread = new Thread(runnable);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMonitor() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean go() {
        Object object = this.monitor;
        synchronized (object) {
            while (this.pause) {
                this.firePausedMessage();
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    msgCenter.warn((Object)"Caught InterruptedException when running simulation, unpausing.", (Throwable)e, new Object[0]);
                    this.fireRestartedMessage();
                    break;
                }
                this.fireRestartedMessage();
            }
        }
        return !this.stop;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
        if (!pause) {
            this.notifyMonitor();
        }
    }

    public void step() {
        this.step = true;
        if (this.pause) {
            this.pause = false;
            this.notifyMonitor();
        }
    }

    public void stop() {
        this.stop = true;
        if (this.pause) {
            this.pause = false;
            this.notifyMonitor();
        }
    }

    public TickListener getTickListener() {
        return this.tickListener;
    }

    public void setTickListener(TickListener tickListener) {
        this.tickListener = tickListener;
    }

    protected ISchedule getSchedule(RunState toExecuteOn) {
        return toExecuteOn.getScheduleRegistry().getModelSchedule();
    }

    class ScheduleLoopRunnable
    implements Runnable {
        private ISchedule schedule;

        public ScheduleLoopRunnable(ISchedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void run() {
            InteractivBatchRunner.this.fireStartedMessage();
            try {
                while (InteractivBatchRunner.this.go() && this.schedule.getActionCount() > 0) {
                    if (this.schedule.getModelActionCount() == 0) {
                        this.schedule.setFinishing(true);
                    }
                    this.schedule.execute();
                    if (InteractivBatchRunner.this.step) {
                        InteractivBatchRunner.this.pause = true;
                        InteractivBatchRunner.this.step = false;
                    }
                    if (InteractivBatchRunner.this.tickListener == null) continue;
                    InteractivBatchRunner.this.tickListener.tickCountUpdated(this.schedule.getTickCount());
                }
                this.schedule.executeEndActions();
            }
            catch (RuntimeException ex) {
                msgCenter.fatal((Object)("RunTimeException when running the schedule\nCurrent tick (" + (this.schedule != null ? String.valueOf(this.schedule.getTickCount()) : "unavailable") + ")"), (Throwable)ex, new Object[0]);
            }
            InteractivBatchRunner.this.fireStoppedMessage();
        }
    }
}

