/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.BasicConfigurator;
import repast.simphony.batch.BatchMain;
import repast.simphony.runtime.RepastBatchMain;

public class BatchTest
extends TestCase {
    public static final int NUM_AGENTS = 10;
    public static final int END_AT = 10;
    public static boolean OPT = false;
    public static Set results = new HashSet();
    public static List<Object[]> paramResults = new ArrayList<Object[]>();
    private String paramsPath;

    static {
        BasicConfigurator.configure();
    }

    public void setUp() {
        results.clear();
        paramResults.clear();
        URL url = ((Object)((Object)this)).getClass().getResource("test_batch_params.xml");
        File f = new File(url.getFile());
        this.paramsPath = f.getAbsolutePath();
        OPT = false;
    }

    public void testSimpleBatch() throws Exception {
        RepastBatchMain.main((String[])new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator"});
        int i = 1;
        while (i < 3) {
            int j = 0;
            while (j < 10) {
                double k = 1.0;
                while (k <= 10.0) {
                    String key = String.valueOf(j) + ":" + i + ":" + k;
                    BatchTest.assertTrue((String)key, (boolean)results.remove(key));
                    k += 1.0;
                }
                ++j;
            }
            ++i;
        }
        BatchTest.assertEquals((int)0, (int)results.size());
    }

    public void testModelInitBatch() throws Exception {
        BatchMain.main(new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator2"});
        int i = 1;
        while (i < 3) {
            int j = 0;
            while (j < 10) {
                double k = 1.0;
                while (k <= 10.0) {
                    String key = String.valueOf(j) + ":" + i + ":" + k;
                    BatchTest.assertTrue((String)key, (boolean)results.remove(key));
                    k += 1.0;
                }
                ++j;
            }
            ++i;
        }
        BatchTest.assertEquals((int)0, (int)results.size());
    }

    public void testWatcherBatch() throws Exception {
        BatchMain.main(new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator3"});
        int i = 1;
        while (i < 3) {
            int j = 0;
            while (j < 10) {
                String key = String.valueOf(j) + ":" + i + ":" + ((double)j + 1.0);
                BatchTest.assertTrue((String)key, (boolean)results.remove(key));
                ++j;
            }
            ++i;
        }
        BatchTest.assertEquals((int)0, (int)results.size());
    }

    public void testBatchFromFile() throws Exception {
        RepastBatchMain.main((String[])new String[]{"-params", this.paramsPath, "./test/test_scenario.rs"});
        int i = 1;
        while (i < 3) {
            int j = 0;
            while (j < 10) {
                String key = String.valueOf(j) + ":" + i + ":" + ((double)j + 1.0);
                BatchTest.assertTrue((String)key, (boolean)results.remove(key));
                ++j;
            }
            ++i;
        }
        BatchTest.assertEquals((int)0, (int)results.size());
    }

    public void testBatchParamSweepXML() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("test_batch_params2.xml");
        File f = new File(url.getFile());
        this.paramsPath = f.getAbsolutePath();
        RepastBatchMain.main((String[])new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        this.doParamsResultTest();
    }

    public void testBatchParamGroovy() throws Exception {
        File f = new File("./test_scripts/test_batch_params2.groovy");
        this.paramsPath = f.getAbsolutePath();
        BatchMain.main(new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        this.doParamsResultTest();
    }

    public void testBatchParamCustomGroovy() throws Exception {
        File f = new File("./test_scripts/test_batch_params3.groovy");
        this.paramsPath = f.getAbsolutePath();
        BatchMain.main(new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        this.doParamsResultTest();
    }

    public void testBatchParamSweepBSF() throws Exception {
        File f = new File("./test/repast/simphony/batch/test_batch_params2.bsh");
        this.paramsPath = f.getAbsolutePath();
        BatchMain.main(new String[]{"-params", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        this.doParamsResultTest();
    }

    public void testOptParamSweepXML() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("test_opt.properties");
        File f = new File(url.getFile());
        this.paramsPath = f.getAbsolutePath();
        OPT = true;
        BatchMain.main(new String[]{"-opt", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        Object[] array = paramResults.get(paramResults.size() - 1);
        BatchTest.assertEquals((Object)array[0], (Object)20);
        BatchTest.assertEquals((Object)array[1], (Object)25);
    }

    public void testOptParamSweepBSH() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getResource("test_opt_bsh.properties");
        File f = new File(url.getFile());
        this.paramsPath = f.getAbsolutePath();
        OPT = true;
        BatchMain.main(new String[]{"-opt", this.paramsPath, "repast.simphony.batch.BatchTestScenarioCreator4"});
        Object[] array = paramResults.get(paramResults.size() - 1);
        BatchTest.assertEquals((Object)array[0], (Object)20);
        BatchTest.assertEquals((Object)array[1], (Object)25);
    }

    private void doParamsResultTest() {
        BatchTest.assertEquals((int)72, (int)paramResults.size());
        Object[][] expected = new Object[][]{{4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 1L, Float.valueOf(1.0f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 2L, Float.valueOf(1.0f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.8f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(0.9f), "bar", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "foo", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "foo", 2, 2}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "bar", 1, 1}, {4.0, 11L, "hello cormac", false, 3L, Float.valueOf(1.0f), "bar", 2, 2}};
        int i = 0;
        while (i < 72) {
            Object[] array = paramResults.get(i);
            Object[] expArray = expected[i];
            BatchTest.assertEquals((String)"double_const", (Object)((Double)expArray[0]), (Object)((Double)array[0]));
            BatchTest.assertEquals((String)"long_const", (Object)((Long)expArray[1]), (Object)((Long)array[1]));
            BatchTest.assertEquals((String)"string_const", (String)((String)expArray[2]), (String)((String)array[2]));
            BatchTest.assertEquals((String)"boolean_const", (Object)((Boolean)expArray[3]), (Object)((Boolean)array[3]));
            BatchTest.assertEquals((String)"long_param", (Object)((Long)expArray[4]), (Object)((Long)array[4]));
            BatchTest.assertEquals((String)"float_param", (float)((Float)expArray[5]).floatValue(), (float)((Float)array[5]).floatValue(), (float)1.0E-4f);
            BatchTest.assertEquals((String)"string_param", (String)((String)expArray[6]), (String)((String)array[6]));
            BatchTest.assertEquals((String)"RandomSeed", (Object)((Integer)expArray[7]), (Object)((Integer)array[7]));
            BatchTest.assertEquals((String)"RandomHelper.getSeed", (Object)((Integer)expArray[8]), (Object)((Integer)array[8]));
            ++i;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BatchTest.class);
        return suite;
    }
}

