/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import repast.simphony.engine.controller.TickListener;
import repast.simphony.engine.environment.AbstractRunner;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.ISchedule;
import simphony.util.messages.MessageCenter;

public class BatchScheduleRunner
extends AbstractRunner {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(BatchScheduleRunner.class);
    private TickListener tickListener = null;

    public void execute(RunState toExecuteOn) {
        ISchedule schedule = toExecuteOn.getScheduleRegistry().getModelSchedule();
        ScheduleLoopRunnable runnable = new ScheduleLoopRunnable(schedule);
        Thread thread = new Thread(runnable);
        thread.start();
    }

    class ScheduleLoopRunnable
    implements Runnable {
        private ISchedule schedule;

        public ScheduleLoopRunnable(ISchedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void run() {
            BatchScheduleRunner.this.fireStartedMessage();
            try {
                while (BatchScheduleRunner.this.go() && this.schedule.getActionCount() > 0) {
                    if (this.schedule.getModelActionCount() == 0) {
                        this.schedule.setFinishing(true);
                    }
                    this.schedule.execute();
                    if (BatchScheduleRunner.this.tickListener == null) continue;
                    BatchScheduleRunner.this.tickListener.tickCountUpdated(this.schedule.getTickCount());
                }
                this.schedule.executeEndActions();
            }
            catch (Throwable ex) {
                msgCenter.fatal((Object)("BatchSchedule.execute: error when running the schedule\nCurrent tick (" + (this.schedule != null ? String.valueOf(this.schedule.getTickCount()) : "unavailable") + ")"), ex, new Object[0]);
            }
            BatchScheduleRunner.this.fireStoppedMessage();
        }
    }
}

