/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.batch.BatchScenario;
import repast.simphony.data2.engine.ConsoleSinkControllerActionIO;
import repast.simphony.data2.engine.DataInitActionCreator;
import repast.simphony.data2.engine.DataSetControllerActionIO;
import repast.simphony.data2.engine.DataSetsActionCreator;
import repast.simphony.data2.engine.FileSinkControllerActionIO;
import repast.simphony.data2.engine.TextSinkActionCreator;
import repast.simphony.dataLoader.engine.CNDataLoaderControllerActionIO;
import repast.simphony.dataLoader.engine.ContextXMLDataLoaderControllerActionIO;
import repast.simphony.dataLoader.engine.DFDataLoaderControllerActionIO;
import repast.simphony.dataLoader.engine.DataLoaderCompositeActionCreator;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.gis.engine.GISCompositeControllerActionCreator;
import repast.simphony.plugin.CompositeControllerActionCreator;
import repast.simphony.plugin.ControllerActionIOExtensions;
import repast.simphony.scenario.ControllerActionIO;
import repast.simphony.scenario.ScenarioLoader;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.UserPathData;

public class BatchScenarioLoader
extends ScenarioLoader {
    protected List<CompositeControllerActionCreator> parentActionCreators = new ArrayList<CompositeControllerActionCreator>();
    protected ControllerActionIOExtensions ioExt = new ControllerActionIOExtensions();

    public BatchScenarioLoader(File scenarioDir) {
        super(scenarioDir, null);
        this.parentActionCreators.add((CompositeControllerActionCreator)new DataLoaderCompositeActionCreator());
        this.parentActionCreators.add((CompositeControllerActionCreator)new DataSetsActionCreator());
        this.parentActionCreators.add((CompositeControllerActionCreator)new TextSinkActionCreator());
        this.parentActionCreators.add((CompositeControllerActionCreator)new DataInitActionCreator());
        this.parentActionCreators.add((CompositeControllerActionCreator)new GISCompositeControllerActionCreator());
        this.ioExt.addControllerActionIO((ControllerActionIO)new CNDataLoaderControllerActionIO());
        this.ioExt.addControllerActionIO((ControllerActionIO)new DataSetControllerActionIO());
        this.ioExt.addControllerActionIO((ControllerActionIO)new FileSinkControllerActionIO());
        this.ioExt.addControllerActionIO((ControllerActionIO)new ConsoleSinkControllerActionIO());
        this.ioExt.addControllerActionIO((ControllerActionIO)new ContextXMLDataLoaderControllerActionIO());
        this.ioExt.addControllerActionIO((ControllerActionIO)new DFDataLoaderControllerActionIO());
    }

    protected void addParentActions(ContextData contextData, ControllerRegistry registry) {
        String id = contextData.getId();
        for (CompositeControllerActionCreator creator : this.parentActionCreators) {
            ControllerAction action;
            if (creator.isMasterOnly()) {
                if (!id.equals(registry.getMasterContextId())) continue;
                action = creator.createControllerAction();
                registry.addAction((Object)id, null, action);
                registry.registerAction((Object)id, creator.getID(), action);
                continue;
            }
            action = creator.createControllerAction();
            registry.addAction((Object)id, null, action);
            registry.registerAction((Object)id, creator.getID(), action);
        }
        for (ContextData child : contextData.subContexts()) {
            this.addParentActions(child, registry);
        }
    }

    public BatchScenario getScenario() {
        return (BatchScenario)this.scenario;
    }

    protected ControllerActionIOExtensions getIOExts() {
        return this.ioExt;
    }

    protected BatchScenario createScenario(File scenarioDir, ContextData context, UserPathData modelData, Object masterContextId) {
        return new BatchScenario(scenarioDir, context, modelData, masterContextId);
    }
}

