/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.data2.engine.DataSetsActionCreator;
import repast.simphony.data2.engine.TextSinkActionCreator;
import repast.simphony.dataLoader.ContextBuilder;
import repast.simphony.dataLoader.engine.DataLoaderCompositeActionCreator;
import repast.simphony.dataLoader.engine.DataLoaderControllerAction;
import repast.simphony.engine.controller.DefaultControllerRegistry;
import repast.simphony.engine.controller.ScheduledMethodControllerAction;
import repast.simphony.engine.controller.WatcherControllerAction;
import repast.simphony.engine.environment.ControllerAction;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.watcher.WatchAnnotationReader;
import repast.simphony.engine.watcher.WatcheeInstrumentor;
import repast.simphony.engine.watcher.WatcherTrigger;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.ParameterSweeper;
import repast.simphony.plugin.CompositeControllerActionCreator;
import repast.simphony.scenario.ModelInitializer;
import repast.simphony.scenario.Scenario;
import repast.simphony.scenario.data.Classpath;
import repast.simphony.scenario.data.ContextData;
import repast.simphony.scenario.data.UserPathData;
import repast.simphony.util.ClassPathEntry;

public class BatchScenario
extends Scenario {
    private Object masterID;
    private WatchAnnotationReader watchAnnotationReader = null;
    private ScheduledMethodControllerAction scheduleAction = null;
    private List<ActionData> data;
    private WatcheeInstrumentor instrumentor;
    protected ParameterSweeper parameterSweeper;
    protected ModelInitializer userInit = null;
    private boolean usingScoreFile = false;

    public BatchScenario(Object masterContextID) {
        super(new File("."), new ContextData(masterContextID.toString(), new Classpath()), new UserPathData(masterContextID.toString()));
        this.init(masterContextID);
    }

    public BatchScenario(File scenarioDir, ContextData contextData, UserPathData modelData, Object masterContextID) {
        super(scenarioDir, contextData, modelData);
        this.usingScoreFile = true;
        this.init(masterContextID);
    }

    private void init(Object masterContextID) {
        this.masterID = masterContextID;
        this.data = new ArrayList<ActionData>();
        this.instrumentor = new WatcheeInstrumentor();
        WatcherTrigger.initInstance((WatcheeInstrumentor)this.instrumentor);
    }

    public void prepareWatchee(String className, String fieldName, String classpath) {
        this.instrumentor.addFieldToWatch(className, fieldName);
        this.instrumentor.instrument(classpath);
    }

    private void processAgentClasses() throws ClassNotFoundException, IOException {
        if (this.usingScoreFile) {
            Classpath classpath = new Classpath();
            for (ClassPathEntry entry : this.modelData.annotationCPEntries()) {
                classpath.addEntry(entry);
            }
            List annotatedClasses = classpath.getClasses();
            if (this.watchAnnotationReader == null) {
                this.watchAnnotationReader = new WatchAnnotationReader();
                this.scheduleAction = new ScheduledMethodControllerAction();
            }
            this.watchAnnotationReader.processClasses(annotatedClasses);
            this.scheduleAction.processAnnotations(annotatedClasses);
        } else {
            for (Class clazz : this.context.getAgentClasses(true)) {
                if (this.watchAnnotationReader == null) {
                    this.watchAnnotationReader = new WatchAnnotationReader();
                    this.scheduleAction = new ScheduledMethodControllerAction();
                }
                this.watchAnnotationReader.processClass(clazz);
                this.scheduleAction.processAnnotations(clazz);
            }
        }
    }

    public <T extends ContextBuilder> void addDataLoader(Object contextTypeID, T loader) {
        ContextData context = this.getContext();
        DataLoaderControllerAction action = new DataLoaderControllerAction("Data loader for " + contextTypeID, loader, context);
        ActionData actionData = new ActionData((ControllerAction)action, contextTypeID, new DataLoaderCompositeActionCreator().getID());
        this.data.add(actionData);
    }

    private void registerContextID(ControllerRegistry registry, ContextData parent) {
        int i = 0;
        while (i < parent.getSubContextCount()) {
            ContextData child = parent.getSubContext(i);
            registry.addContextId((Object)parent.getId(), (Object)child.getId());
            this.registerContextID(registry, child);
            ++i;
        }
    }

    private void addParentActions(ControllerRegistry registry) {
        ArrayList<Object> parentActionCreators = new ArrayList<Object>();
        parentActionCreators.add(new DataLoaderCompositeActionCreator());
        parentActionCreators.add(new DataSetsActionCreator());
        parentActionCreators.add(new TextSinkActionCreator());
        for (CompositeControllerActionCreator compositeControllerActionCreator : parentActionCreators) {
            ControllerAction action = compositeControllerActionCreator.createControllerAction();
            registry.addAction(this.masterID, null, action);
            registry.registerAction(this.masterID, compositeControllerActionCreator.getID(), action);
        }
        for (ActionData actionData : this.data) {
            Object contextID = actionData.contextType;
            for (CompositeControllerActionCreator compositeControllerActionCreator : parentActionCreators) {
                ControllerAction action = compositeControllerActionCreator.createControllerAction();
                registry.addAction(contextID, null, action);
                registry.registerAction(contextID, compositeControllerActionCreator.getID(), action);
            }
        }
    }

    public ControllerRegistry createRegistry(RunEnvironmentBuilder builder) throws ClassNotFoundException, IOException {
        this.processAgentClasses();
        DefaultControllerRegistry registry = new DefaultControllerRegistry();
        registry.setMasterContextId(this.masterID);
        this.registerContextID((ControllerRegistry)registry, this.context);
        this.addParentActions((ControllerRegistry)registry);
        if (this.userInit != null) {
            this.userInit.initialize((Scenario)this, builder);
        }
        for (ActionData actionData : this.data) {
            ControllerAction parent = registry.findAction(actionData.contextType, actionData.parentAction);
            registry.addAction(actionData.contextType, parent, actionData.action);
        }
        registry.addAction(registry.getMasterContextId(), null, DEFAULT_MASTER_PARENT);
        for (ControllerAction action : this.masterActions) {
            registry.addAction(registry.getMasterContextId(), DEFAULT_MASTER_PARENT, action);
        }
        if (this.parameterSweeper != null) {
            registry.addParameterSetter((ParameterSetter)this.parameterSweeper);
            for (ParameterSetter sweeper : this.paramSweepers) {
                this.parameterSweeper.add(null, sweeper);
            }
        }
        ControllerAction scheduleRoot = registry.findAction(this.masterID, "repast.controller.action.schedule");
        WatcherControllerAction watcherAction = new WatcherControllerAction(this.watchAnnotationReader);
        registry.addAction(this.masterID, scheduleRoot, (ControllerAction)watcherAction);
        registry.addAction(this.masterID, scheduleRoot, (ControllerAction)this.scheduleAction);
        this.registry = registry;
        return registry;
    }

    public ModelInitializer getModelInitializer() {
        if (this.userInit != null) {
            return this.userInit;
        }
        try {
            return super.getModelInitializer();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void setUserInitializer(ModelInitializer userInit) {
        this.userInit = userInit;
    }

    public void setParameterSweeper(ParameterSweeper sweeper) {
        this.parameterSweeper = sweeper;
    }

    public ParameterSweeper getParameterSweeper() {
        return this.parameterSweeper;
    }

    private static class ActionData {
        Object contextType;
        String parentAction;
        ControllerAction action;

        public ActionData(ControllerAction action, Object contextType, String parentAction) {
            this.action = action;
            this.contextType = contextType;
            this.parentAction = parentAction;
        }
    }
}

