/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import repast.simphony.batch.BatchScenario;
import repast.simphony.batch.BatchScenarioCreator;
import repast.simphony.batch.BatchScenarioLoader;
import repast.simphony.batch.BatchScheduleRunner;
import repast.simphony.batch.InteractivBatchRunner;
import repast.simphony.engine.controller.Controller;
import repast.simphony.engine.controller.DefaultController;
import repast.simphony.engine.environment.AbstractRunner;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultRunEnvironmentBuilder;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.environment.Runner;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.scenario.ScenarioLoadException;
import simphony.util.messages.MessageCenter;

public class BatchRunner
implements RunListener {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(BatchRunner.class);
    private RunEnvironmentBuilder runEnvironmentBuilder;
    protected Controller controller;
    protected boolean pause = false;
    protected Object monitor = new Object();
    protected SweeperProducer producer;

    public BatchRunner(boolean interactive) {
        AbstractRunner scheduleRunner = null;
        scheduleRunner = interactive ? new InteractivBatchRunner() : new BatchScheduleRunner();
        scheduleRunner.addRunListener((RunListener)this);
        this.runEnvironmentBuilder = new DefaultRunEnvironmentBuilder((Runner)scheduleRunner, true);
        this.controller = new DefaultController(this.runEnvironmentBuilder);
        this.controller.setScheduleRunner((Runner)scheduleRunner);
    }

    public BatchRunner(boolean interactive, int runNumber) {
        AbstractRunner scheduleRunner = null;
        scheduleRunner = interactive ? new InteractivBatchRunner() : new BatchScheduleRunner();
        scheduleRunner.addRunListener((RunListener)this);
        this.runEnvironmentBuilder = new DefaultRunEnvironmentBuilder((Runner)scheduleRunner, true);
        this.controller = new DefaultController(this.runEnvironmentBuilder, runNumber);
        this.controller.setScheduleRunner((Runner)scheduleRunner);
    }

    public BatchRunner() {
    }

    public SweeperProducer getSweeperProducer() {
        return this.producer;
    }

    public void setSweeperProducer(SweeperProducer producer) {
        this.producer = producer;
    }

    public void run(File scenarioDir) throws ScenarioLoadException {
        if (!scenarioDir.exists()) {
            msgCenter.error((Object)"Scenario not found", (Throwable)new IllegalArgumentException("Invalid scenario " + scenarioDir.getAbsolutePath()), new Object[0]);
            return;
        }
        BatchScenarioLoader loader = new BatchScenarioLoader(scenarioDir);
        ControllerRegistry registry = loader.load(this.runEnvironmentBuilder);
        this.controller.setControllerRegistry(registry);
        this.run();
    }

    public void loadScenario(File scenarioDir) throws ScenarioLoadException {
        if (!scenarioDir.exists()) {
            msgCenter.error((Object)"Scenario not found", (Throwable)new IllegalArgumentException("Invalid scenario " + scenarioDir.getAbsolutePath()), new Object[0]);
            return;
        }
        BatchScenarioLoader loader = new BatchScenarioLoader(scenarioDir);
        ControllerRegistry registry = loader.load(this.runEnvironmentBuilder);
        this.controller.setControllerRegistry(registry);
    }

    public void run(BatchScenarioCreator creator) throws ClassNotFoundException, IOException {
        BatchScenario scenario = creator.createScenario();
        this.controller.setControllerRegistry(scenario.createRegistry(this.runEnvironmentBuilder));
        this.run();
    }

    public void createScenario(BatchScenarioCreator creator) throws ClassNotFoundException, IOException {
        BatchScenario scenario = creator.createScenario();
        this.controller.setControllerRegistry(scenario.createRegistry(this.runEnvironmentBuilder));
    }

    protected boolean keepRunning() {
        for (ParameterSetter setter : this.controller.getControllerRegistry().getParameterSetters()) {
            if (setter.atEnd()) continue;
            return true;
        }
        return false;
    }

    private Parameters setupSweep() throws IOException {
        ParametersCreator creator;
        Parameters params = null;
        ControllerRegistry registry = this.controller.getControllerRegistry();
        if (this.producer != null) {
            this.producer.init(registry, registry.getMasterContextId());
            params = this.producer.getParameters();
            registry.addParameterSetter((ParameterSetter)this.producer.getParameterSweeper());
        }
        if (params == null) {
            creator = new ParametersCreator();
            params = creator.createParameters();
        }
        if (!params.getSchema().contains("randomSeed")) {
            creator = new ParametersCreator();
            creator.addParameters(params);
            creator.addParameter("randomSeed", Integer.class, (Object)((int)System.currentTimeMillis()), false);
            params = creator.createParameters();
        }
        return params;
    }

    protected void run() {
        Parameters params = null;
        try {
            params = this.setupSweep();
        }
        catch (MalformedURLException e) {
            msgCenter.error((Object)"Error creating parameters and parameter sweeper", (Throwable)e, new Object[0]);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            msgCenter.error((Object)"Error creating parameters and parameter sweeper", (Throwable)e, new Object[0]);
            return;
        }
        this.controller.batchInitialize();
        while (this.keepRunning()) {
            this.pause = true;
            this.controller.runParameterSetters(params);
            this.controller.runInitialize(params);
            this.controller.execute();
            this.waitForRun();
            this.controller.runCleanup();
            System.gc();
        }
        this.controller.batchCleanup();
        System.gc();
    }

    protected void printMemoryStats(String header) {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("UFTM:" + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb + " " + runtime.freeMemory() / (long)mb + " " + runtime.totalMemory() / (long)mb + " " + runtime.maxMemory() / (long)mb + " " + header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRun() {
        Object object = this.monitor;
        synchronized (object) {
            while (this.pause) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMonitor() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public void paused() {
    }

    public void restarted() {
    }

    public void started() {
    }

    public void stopped() {
        this.pause = false;
        this.notifyMonitor();
    }
}

