/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import repast.simphony.batch.BatchRunner;
import repast.simphony.batch.BatchScenarioCreator;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.parameter.bsf.ScriptRunner;
import repast.simphony.parameter.groovy.GroovyRunner;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.OptPropertiesParser;
import repast.simphony.parameter.xml.OptimizedXMLSweeperProducer;
import repast.simphony.parameter.xml.XMLSweeperProducer;
import simphony.util.messages.MessageCenter;

public class BatchMain {
    static MessageCenter msgCenter = MessageCenter.getMessageCenter(BatchMain.class);
    private Options options = new Options();
    private static Map<String, byte[]> htJarContents = new HashMap<String, byte[]>();

    public BatchMain() {
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given parameter sweep file");
        Option paramfile = OptionBuilder.create((String)"params");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"use optimizable parameter sweeper with given optimizing properties file");
        Option opt = OptionBuilder.create((String)"opt");
        OptionBuilder.withDescription((String)"specifies if the batch mode is interactive");
        Option mode = OptionBuilder.create((String)"interactive");
        this.options.addOption(help);
        this.options.addOption(paramfile);
        this.options.addOption(opt);
        this.options.addOption(mode);
    }

    @Deprecated
    public void run(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("help") || args.length < 1) {
                this.showHelp();
                System.exit(0);
            }
            BatchRunner runner = line.hasOption("interactive") ? new BatchRunner(true) : new BatchRunner(false);
            SweeperProducer producer = null;
            if (line.hasOption("opt")) {
                String file = line.getOptionValue("opt");
                OptPropertiesParser optParser = new OptPropertiesParser(new File(file));
                RunResultProducer rrProducer = optParser.getRunResultProducer();
                AdvancementChooser chooser = optParser.getAdvancementChooser();
                if (optParser.getParametersFile() != null) {
                    String paramsFile = optParser.getParametersFile();
                    producer = chooser == null ? new OptimizedXMLSweeperProducer(rrProducer, new File(paramsFile).toURL()) : new OptimizedXMLSweeperProducer(rrProducer, chooser, new File(paramsFile).toURL());
                } else {
                    String scriptFile = optParser.getBSFScript();
                    producer = chooser == null ? new ScriptRunner(rrProducer, new File(scriptFile)) : new ScriptRunner(rrProducer, chooser, new File(scriptFile));
                }
            } else {
                String params = line.getOptionValue("params");
                if (params != null) {
                    if (params.endsWith("xml")) {
                        producer = new XMLSweeperProducer(new File(params).toURL());
                    } else if (params.endsWith("bsh")) {
                        producer = new ScriptRunner(new File(params));
                    } else if (params.endsWith("groovy")) {
                        producer = new GroovyRunner(new File(params));
                    }
                }
            }
            runner.setSweeperProducer(producer);
            String targetArg = args[args.length - 1];
            File file = new File(targetArg);
            if (file.exists()) {
                runner.run(file);
            } else {
                Class<?> c = Class.forName(targetArg);
                BatchScenarioCreator creator = (BatchScenarioCreator)c.newInstance();
                runner.run(creator);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showHelp();
            msgCenter.fatal((Object)"Fatal error starting repast.simphony simphony.", (Throwable)ex, new Object[0]);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDistributed(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        try {
            Object params;
            CommandLine line = parser.parse(this.options, args);
            if (line.hasOption("help")) {
                this.showHelp();
                System.exit(0);
            }
            String targetArg = args[2];
            File file = new File(targetArg);
            BatchRunner runner = line.hasOption("interactive") ? new BatchRunner(true, Integer.parseInt(args[6])) : new BatchRunner(false, Integer.parseInt(args[6]));
            SweeperProducer producer = null;
            if (line.hasOption("opt")) {
                String f = line.getOptionValue("opt");
                OptPropertiesParser optParser = new OptPropertiesParser(new File(f));
                RunResultProducer rrProducer = optParser.getRunResultProducer();
                AdvancementChooser chooser = optParser.getAdvancementChooser();
                if (optParser.getParametersFile() != null) {
                    String paramsFile = optParser.getParametersFile();
                    producer = chooser == null ? new OptimizedXMLSweeperProducer(rrProducer, new File(paramsFile).toURL()) : new OptimizedXMLSweeperProducer(rrProducer, chooser, new File(paramsFile).toURL());
                } else {
                    String scriptFile = optParser.getBSFScript();
                    producer = chooser == null ? new ScriptRunner(rrProducer, new File(scriptFile)) : new ScriptRunner(rrProducer, chooser, new File(scriptFile));
                }
            } else {
                params = line.getOptionValue("params");
                if (params != null) {
                    if (((String)params).endsWith(".xml")) {
                        String read = args[7];
                        producer = file.exists() ? new XMLSweeperProducer(new File(args[1]).toURL()) : new XMLSweeperProducer(new File(args[5]).toURL());
                        ((XMLSweeperProducer)producer).parser.inputFile(read);
                    } else if (((String)params).endsWith("bsh")) {
                        producer = new ScriptRunner(new File((String)params));
                    } else if (((String)params).endsWith("groovy")) {
                        producer = new GroovyRunner(new File((String)params));
                    }
                }
            }
            runner.setSweeperProducer(producer);
            if (file.exists()) {
                runner.run(file);
            } else if (!file.exists()) {
                while (!new File(args[3]).exists()) {
                    params = this;
                    synchronized (params) {
                        this.wait(100L);
                    }
                }
                runner.run(new File(args[3]));
            } else {
                Class<?> c = Class.forName(targetArg);
                BatchScenarioCreator creator = (BatchScenarioCreator)c.newInstance();
                runner.run(creator);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showHelp();
            msgCenter.fatal((Object)"Fatal error starting repast.simphony simphony.", (Throwable)ex, new Object[0]);
            throw ex;
        }
    }

    public void processJar(String name) {
        String arg = "jar xf " + name;
        try {
            Runtime.getRuntime().exec(arg);
        }
        catch (IOException e) {
            msgCenter.fatal((Object)"Bad jar file, could not extract jar file", (Throwable)e, new Object[0]);
        }
    }

    private void showHelp() {
        HelpFormatter formatter = new HelpFormatter();
        String header = "Where target is the path to a scenario file or the fully qualified name of a class that implements repast.simphony.batch.BatchScenarioCreator.\n";
        formatter.printHelp(String.valueOf(BatchMain.class.getName()) + " [options] target", header, this.options, "");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            new BatchMain().run(args);
        } else {
            new BatchMain().runDistributed(args);
        }
    }
}

