/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.cli.CommandLine;
import repast.simphony.batch.BatchRunner;
import repast.simphony.batch.BatchScenarioCreator;
import repast.simphony.parameter.RunResultProducer;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.parameter.bsf.ScriptRunner;
import repast.simphony.parameter.groovy.GroovyRunner;
import repast.simphony.parameter.optimizer.AdvancementChooser;
import repast.simphony.parameter.optimizer.OptPropertiesParser;
import repast.simphony.parameter.xml.OptimizedXMLSweeperProducer;
import repast.simphony.parameter.xml.XMLSweeperProducer;

public class BatchInit {
    public void run(CommandLine line, String[] args) throws Exception {
        BatchRunner runner = line.hasOption("interactive") ? new BatchRunner(true) : new BatchRunner(false);
        String targetArg = args[args.length - 1];
        File file = new File(targetArg);
        if (file.exists()) {
            runner.loadScenario(file);
        } else {
            Class<?> c = Class.forName(targetArg);
            BatchScenarioCreator creator = (BatchScenarioCreator)c.newInstance();
            runner.createScenario(creator);
        }
        SweeperProducer producer = null;
        if (line.hasOption("opt")) {
            producer = this.runOpt(line);
        } else {
            String params = line.getOptionValue("params");
            if (params != null) {
                if (params.endsWith("xml")) {
                    producer = new XMLSweeperProducer(new File(params).toURI().toURL());
                } else if (params.endsWith("bsh")) {
                    producer = new ScriptRunner(new File(params));
                } else if (params.endsWith("groovy")) {
                    producer = new GroovyRunner(new File(params));
                }
            }
        }
        runner.setSweeperProducer(producer);
        runner.run();
    }

    private SweeperProducer runOpt(CommandLine line) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, MalformedURLException {
        SweeperProducer producer;
        String file = line.getOptionValue("opt");
        OptPropertiesParser optParser = new OptPropertiesParser(new File(file));
        RunResultProducer rrProducer = optParser.getRunResultProducer();
        AdvancementChooser chooser = optParser.getAdvancementChooser();
        if (optParser.getParametersFile() != null) {
            String paramsFile = optParser.getParametersFile();
            producer = chooser == null ? new OptimizedXMLSweeperProducer(rrProducer, new File(paramsFile).toURI().toURL()) : new OptimizedXMLSweeperProducer(rrProducer, chooser, new File(paramsFile).toURI().toURL());
        } else {
            String scriptFile = optParser.getBSFScript();
            producer = chooser == null ? new ScriptRunner(rrProducer, new File(scriptFile)) : new ScriptRunner(rrProducer, chooser, new File(scriptFile));
        }
        return producer;
    }
}

