/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import util.Statistics;

public abstract class Sampler
implements Runnable {
    private final int intervalMillis;
    private final AtomicBoolean doStop;
    private boolean isDone;
    private final ReentrantLock lock;
    private final Condition done;
    private final Random random;

    protected Sampler(int intervalMillis) {
        this.intervalMillis = intervalMillis;
        this.doStop = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
        this.done = this.lock.newCondition();
        this.random = new Random();
    }

    protected abstract void sample();

    protected abstract Statistics dumpSamples();

    @Override
    public void run() {
        while (!this.doStop.get()) {
            try {
                int sleepTime = this.intervalMillis - this.intervalMillis / 2 + this.random.nextInt(this.intervalMillis);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.sample();
        }
        this.lock.lock();
        try {
            this.isDone = true;
            this.done.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Statistics stop() {
        if (this.intervalMillis > 0) {
            this.doStop.set(true);
            this.lock.lock();
            try {
                while (!this.isDone) {
                    this.done.await();
                }
                Statistics statistics = this.dumpSamples();
                return statistics;
            }
            catch (InterruptedException e) {
                throw new Error(e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    protected static final Sampler start(Sampler sampler) {
        if (sampler.intervalMillis > 0) {
            Thread t = new Thread((Runnable)sampler, "Sampler");
            t.setDaemon(true);
            t.start();
        }
        return sampler;
    }
}

