/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import util.Statistics;

public class RuntimeStatistics
extends Statistics {
    private final List<Long> times = new ArrayList<Long>();
    private final List<Long> timesWithGc = new ArrayList<Long>();

    public void putStats(long time, long timeWithGc) {
        this.times.add(time);
        this.timesWithGc.add(timeWithGc);
    }

    @Override
    public void dumpFull(PrintStream out) {
        this.printFullHeader(out, "Runtimes");
        out.printf("Without GC (ms): %s\n", this.times);
        this.summarizeLongs(out, this.times, 0, "\t");
        out.printf("With GC (ms): %s\n", this.timesWithGc);
        this.summarizeLongs(out, this.timesWithGc, 0, "\t");
    }

    @Override
    public void dumpSummary(PrintStream out) {
        this.printSummaryHeader(out, "Runtimes (ms)");
        float[] wgc = this.summarizeLongs(this.timesWithGc, 1);
        float[] wogc = this.summarizeLongs(this.times, 1);
        boolean output = wgc != null;
        this.summarizeLongs(out, this.timesWithGc, 1, "", output);
        if (output) {
            float rel = 0.0f;
            if (wgc[0] != 0.0f) {
                rel = (wgc[0] - wogc[0]) / wgc[0];
            }
            out.printf(" Rel. GC time: %.4f\n", Float.valueOf(rel));
        }
    }

    @Override
    public void merge(Object obj) {
        RuntimeStatistics other = (RuntimeStatistics)obj;
        this.times.addAll(other.times);
        this.timesWithGc.addAll(other.timesWithGc);
    }
}

