/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class Reflection {
    public static boolean packageContainsAnnotation(String className, Class<? extends Annotation> annotationClass) {
        return Reflection.getPackageAnnotation(className, annotationClass) != null;
    }

    public static <A extends Annotation> A getPackageAnnotation(String className, Class<A> annotationClass) {
        Class<?> classClass = null;
        try {
            classClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Package classPackage = Package.getPackage(classClass.getPackage().getName());
        return classPackage.getAnnotation(annotationClass);
    }

    public static boolean containsAnnotation(String className, Class<? extends Annotation> annotationClass) {
        return Reflection.getAnnotation(className, annotationClass) != null;
    }

    public static <A extends Annotation> A getAnnotation(String className, Class<A> annotationClass) {
        Class<?> classClass = null;
        try {
            classClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return classClass.getAnnotation(annotationClass);
    }

    public static Object createObject(String className) {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return object;
    }

    public static Object invokeMethod(Object o, String methodName, Object[] params) {
        String className = o.getClass().getName();
        ArrayList<Object> actualParams = new ArrayList<Object>(Arrays.asList(params));
        actualParams.add(0, o);
        return Reflection.invokeStaticMethod(className, methodName, actualParams.toArray());
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] params) {
        Method[] methods;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Method[] methodArray = methods = c.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                try {
                    method.setAccessible(true);
                    return method.invoke(null, params);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ite) {
                    throw new RuntimeException(ite);
                }
            }
            ++n2;
        }
        throw new RuntimeException("Method '" + methodName + "' not found");
    }
}

