/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import util.Statistics;
import util.ThreadTimer;

public class Launcher {
    private static Launcher instance;
    private boolean isFirstRun = true;
    private ThreadTimer.Tick start;
    private ThreadTimer.Tick stop;
    private final List<Statistics> stats = new ArrayList<Statistics>();
    private final List<Runnable> callbacks = new ArrayList<Runnable>();
    private final Random random = new Random();

    private Launcher() {
    }

    public void startTiming() {
        System.gc();
        if (this.stop == null) {
            this.start = ThreadTimer.tick();
        }
    }

    public void stopTiming() {
        if (this.stop == null) {
            this.stop = ThreadTimer.tick();
        }
    }

    public boolean isFirstRun() {
        return this.isFirstRun;
    }

    public long elapsedTime(boolean withoutGc) {
        return this.start.elapsedTime(withoutGc, this.stop);
    }

    public void reset() {
        this.stop = null;
        this.start = null;
        this.isFirstRun = false;
        for (Runnable r : this.callbacks) {
            r.run();
        }
        this.callbacks.clear();
        this.stats.clear();
    }

    public List<Statistics> getStatistics() {
        return this.stats;
    }

    public void onRestart(Runnable callback) {
        this.callbacks.add(callback);
    }

    public void addStats(Statistics stat) {
        if (stat != null) {
            this.stats.add(stat);
        }
    }

    public Random getRandom(int seed) {
        this.random.setSeed(seed);
        return this.random;
    }

    public static Launcher getLauncher() {
        if (instance == null) {
            instance = new Launcher();
        }
        return instance;
    }
}

