/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Collection;
import util.Pair;
import util.fn.FnIterable;
import util.fn.Lambda;
import util.fn.Lambda2;

public class CollectionMath {
    public static Integer sumInteger(Iterable<Integer> c) {
        return CollectionMath.sumInteger(FnIterable.from(c));
    }

    public static Integer sumInteger(FnIterable<Integer> it) {
        return it.reduce(new Lambda2<Integer, Integer, Integer>(){

            @Override
            public Integer call(Integer arg0, Integer arg1) {
                return arg0 + arg1;
            }
        }, 0);
    }

    public static Collection<Integer> sumInteger(Iterable<Integer> c1, Collection<Integer> c2) {
        return CollectionMath.sumInteger(FnIterable.from(c1), FnIterable.from(c2)).toList();
    }

    public static FnIterable<Integer> sumInteger(FnIterable<Integer> c1, FnIterable<Integer> c2) {
        return c1.zip(c2).map(new Lambda<Pair<Integer, Integer>, Integer>(){

            @Override
            public Integer call(Pair<Integer, Integer> x) {
                return x.getFirst() + x.getSecond();
            }
        });
    }

    public static Long sumLong(Iterable<Long> c) {
        return CollectionMath.sumLong(FnIterable.from(c));
    }

    public static Long sumLong(FnIterable<Long> it) {
        return it.reduce(new Lambda2<Long, Long, Long>(){

            @Override
            public Long call(Long arg0, Long arg1) {
                return arg0 + arg1;
            }
        }, 0L);
    }

    public static Collection<Long> sumLong(Iterable<Long> c1, Iterable<Long> c2) {
        return CollectionMath.sumLong(FnIterable.from(c1), FnIterable.from(c2)).toList();
    }

    public static FnIterable<Long> sumLong(FnIterable<Long> c1, FnIterable<Long> c2) {
        return c1.zip(c2).map(new Lambda<Pair<Long, Long>, Long>(){

            @Override
            public Long call(Pair<Long, Long> x) {
                return x.getFirst() + x.getSecond();
            }
        });
    }

    public static Float sumFloat(Iterable<Float> c) {
        return CollectionMath.sumFloat(FnIterable.from(c));
    }

    public static Float sumFloat(FnIterable<Float> it) {
        return it.reduce(new Lambda2<Float, Float, Float>(){

            @Override
            public Float call(Float arg0, Float arg1) {
                return Float.valueOf(arg0.floatValue() + arg1.floatValue());
            }
        }, Float.valueOf(0.0f));
    }

    public static Collection<Float> sumFloat(Iterable<Float> c1, Iterable<Float> c2) {
        return CollectionMath.sumFloat(FnIterable.from(c1), FnIterable.from(c2)).toList();
    }

    public static FnIterable<Float> sumFloat(FnIterable<Float> c1, FnIterable<Float> c2) {
        return c1.zip(c2).map(new Lambda<Pair<Float, Float>, Float>(){

            @Override
            public Float call(Pair<Float, Float> x) {
                return Float.valueOf(x.getFirst().floatValue() + x.getSecond().floatValue());
            }
        });
    }
}

