/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentRandomPermutation;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentRandomPermutation.class)
@MatchingLeafVersion(value=RandomPermutation.class)
public class RandomPermutation<T>
implements Worklist<T> {
    private final List<T> items = new ArrayList<T>();

    public RandomPermutation(Maker<T> maker, boolean needSize) {
        this(needSize);
    }

    private RandomPermutation(boolean needSize) {
    }

    @Override
    public Worklist<T> newInstance() {
        return new RandomPermutation<T>(false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.items.add(item);
    }

    @Override
    public void finishAddInitial() {
        Collections.shuffle(this.items);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int size = this.items.size();
        T retval = null;
        if (size != 0) {
            retval = this.items.remove(size - 1);
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public int size() {
        return this.items.size();
    }
}

