/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentRandomOrder;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.Arrays;
import java.util.Random;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentRandomOrder.class)
@MatchingLeafVersion(value=RandomOrder.class)
public class RandomOrder<T>
implements Worklist<T> {
    private T[] queue;
    private int size;
    private final Random rand;

    public RandomOrder(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public RandomOrder(int startingSize, Maker<T> maker, boolean needSize) {
        this.queue = new Object[startingSize];
        this.size = 0;
        this.rand = new Random();
    }

    @Override
    public Worklist<T> newInstance() {
        return new RandomOrder<T>(this.queue.length, null, false);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = null;
        if (this.size != 0) {
            int bucket = this.rand.nextInt(this.size);
            retval = this.queue[bucket];
            this.queue[bucket] = this.queue[this.size - 1];
            this.queue[this.size - 1] = null;
            --this.size;
        }
        return retval;
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        if (this.size + 1 >= this.queue.length) {
            this.resize();
        }
        this.queue[this.size++] = item;
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void finishAddInitial() {
    }

    private void resize() {
        this.queue = Arrays.copyOf(this.queue, this.queue.length * 2);
    }
}

