/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.wl.BoundedFIFO;
import galois.runtime.wl.BoundedLIFO;
import galois.runtime.wl.ChunkedFIFO;
import galois.runtime.wl.ChunkedLIFO;
import galois.runtime.wl.FIFO;
import galois.runtime.wl.LIFO;
import galois.runtime.wl.LocalWorklist;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NeedsSize;
import galois.runtime.wl.NestedAreSerial;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.OrderableWorklist;
import galois.runtime.wl.ParameterOrderedWorklist;
import galois.runtime.wl.ParameterUnorderedWorklist;
import galois.runtime.wl.Worklist;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import util.Pair;

public class Priority {
    private static <T> Worklist<T> make(boolean isSerial, Rule rule) {
        Pair<Rule, Rule> result = rule.findFirstAndLocal();
        Rule first = result.getFirst();
        Rule local = result.getSecond();
        first.updateRules(isSerial);
        if (local != null) {
            local.updateRules(true);
            Maker outerMaker = first.gen();
            Maker innerMaker = local.gen();
            return new LocalWorklist(outerMaker, innerMaker);
        }
        return first.gen().make();
    }

    public static <T> Worklist<T> makeSerial(Rule rule) {
        return Priority.make(true, rule);
    }

    public static <T> Worklist<T> makeUnordered(Rule rule) {
        return Priority.make(false, rule);
    }

    public static <T> OrderableWorklist<T> makeOrdered(Rule rule) {
        Worklist<T> wl = Priority.make(false, rule);
        if (wl instanceof OrderableWorklist) {
            return (OrderableWorklist)wl;
        }
        throw new Error("Rule does not make ordered worklist, use Ordered rules");
    }

    public static <T> ParameterOrderedWorklist<T> makeParameterOrdered(Rule rule) {
        OrderableWorklist<T> wl = Priority.makeOrdered(rule);
        return new ParameterOrderedWorklist<T>(wl.getComparator());
    }

    public static <T> ParameterUnorderedWorklist<T> makeParameterUnordered() {
        return new ParameterUnorderedWorklist();
    }

    public static Rule defaultOrder() {
        return new Rule().then(ChunkedFIFO.class, new Object[0]);
    }

    public static Rule first(Class<? extends Worklist> rule, Object ... args) {
        return new Rule().then(rule, args);
    }

    public static <T> Rule withWorklist(final Worklist<T> worklist) {
        return new Rule(){

            @Override
            public Rule then(Class<? extends Worklist> rule, Object ... arg) {
                throw new UnsupportedOperationException();
            }

            @Override
            Pair<Rule, Rule> findFirstAndLocal() {
                return new Pair<1, Object>(this, null);
            }

            @Override
            void updateRules(boolean isSerial) {
            }

            @Override
            Maker<T> gen() {
                return new Maker<T>(){

                    @Override
                    public Worklist<T> make() {
                        return worklist;
                    }
                };
            }
        };
    }

    public static class Rule {
        private static Object[] emptyArgs = new Object[0];
        private Rule prev;
        private Rule next;
        private Class<?> rule;
        private Object[] args = emptyArgs;
        private boolean needSize;
        private boolean isLocalRule;

        private Rule() {
        }

        public Rule then(Class<? extends Worklist> rule, Object ... args) {
            this.rule = rule;
            this.args = args;
            this.next = new Rule();
            this.next.prev = this;
            return this.next;
        }

        public Rule thenLocally(Class<? extends Worklist> rule, Object ... args) {
            this.isLocalRule = true;
            return this.then(rule, args);
        }

        private void cutAt() {
            this.prev.next = new Rule();
            this.prev = null;
        }

        Pair<Rule, Rule> findFirstAndLocal() {
            Rule first = this;
            while (first.prev != null) {
                first = first.prev;
            }
            Rule local = first;
            while (local != null) {
                if (local.isLocalRule) {
                    local.cutAt();
                    break;
                }
                local = local.next;
            }
            return new Pair<Rule, Rule>(first, local);
        }

        private void updateSerial(boolean isSerial) {
            boolean nextIsSerial;
            boolean bl = nextIsSerial = isSerial || this.rule.isAnnotationPresent(NestedAreSerial.class);
            if (!isSerial) {
                this.rule = this.rule.getAnnotation(MatchingConcurrentVersion.class).value();
            }
            if (this.next.rule != null) {
                this.next.updateSerial(nextIsSerial);
            }
        }

        private void updateLeaf() {
            if (this.next.rule == null) {
                MatchingLeafVersion leaf = this.rule.getAnnotation(MatchingLeafVersion.class);
                if (leaf != null) {
                    this.rule = leaf.value();
                }
            } else {
                if (this.rule.isAnnotationPresent(OnlyLeaf.class)) {
                    throw new Error("Leaf rule used in non-leaf position: " + this.rule);
                }
                this.next.updateLeaf();
            }
        }

        private void updateBounded() {
            if (this.prev != null && (this.prev.rule == ChunkedFIFO.class || this.prev.rule == ChunkedLIFO.class)) {
                if (this.rule == FIFO.class || this.rule == BoundedFIFO.class) {
                    this.rule = BoundedFIFO.class;
                    this.args = this.prev.args;
                } else if (this.rule == LIFO.class || this.rule == BoundedLIFO.class) {
                    this.rule = BoundedLIFO.class;
                    this.args = this.prev.args;
                }
            }
            if (this.next.rule != null) {
                this.next.updateBounded();
            }
        }

        void updateRules(boolean isSerial) {
            this.updateNeedSize(false);
            this.updateLeaf();
            this.updateBounded();
            this.updateSerial(isSerial);
        }

        private void updateNeedSize(boolean needSize) {
            this.needSize = needSize;
            if (this.rule == null) {
                return;
            }
            boolean nextNeedSize = this.rule.isAnnotationPresent(NeedsSize.class);
            if (this.next != null) {
                this.next.updateNeedSize(nextNeedSize);
            }
        }

        <T> Maker<T> gen() {
            if (this.rule == null) {
                return null;
            }
            Maker<T> maker = this.next != null ? this.next.gen() : null;
            int numArgs = this.args.length + 2;
            Constructor<?>[] constructorArray = this.rule.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Constructor<?> c = constructorArray[n2];
                Class<?>[] params = c.getParameterTypes();
                if (params.length == numArgs) {
                    final Object[] actuals = new Object[numArgs];
                    System.arraycopy(this.args, 0, actuals, 0, this.args.length);
                    actuals[this.args.length] = maker;
                    actuals[this.args.length + 1] = this.needSize;
                    return new Maker<T>(){

                        @Override
                        public Worklist<T> make() {
                            try {
                                return (Worklist)c.newInstance(actuals);
                            }
                            catch (Exception e) {
                                throw new Error(e);
                            }
                        }
                    };
                }
                ++n2;
            }
            throw new Error("Couldn't find matching constructor for " + this.rule + " with " + numArgs + " args ");
        }

        public String toString() {
            return String.format("%s(%s)", this.rule != null ? this.rule.getName() : "null", Arrays.toString(this.args));
        }

        /* synthetic */ Rule(Rule rule, Rule rule2) {
            this();
        }
    }
}

