/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentOrdered;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OrderableWorklist;
import galois.runtime.wl.OrderedLeaf;
import galois.runtime.wl.Worklist;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

@MatchingLeafVersion(value=OrderedLeaf.class)
@MatchingConcurrentVersion(value=ConcurrentOrdered.class)
public class Ordered<T>
implements OrderableWorklist<T> {
    private final Worklist<T> empty;
    private final TreeMap<T, Worklist<T>> map;
    private final Comparator<T> comp;
    private final Comparator<T> innerComp;
    private int size;

    public Ordered(Comparator<T> comp, Maker<T> maker, boolean needSize) {
        this(comp, maker.make(), needSize);
    }

    private Ordered(Comparator<T> comp, Worklist<T> empty, boolean needSize) {
        this.empty = empty;
        this.comp = comp;
        this.innerComp = empty instanceof OrderableWorklist ? ((OrderableWorklist)empty).getComparator() : null;
        this.map = new TreeMap(comp);
    }

    @Override
    public Worklist<T> newInstance() {
        return new Ordered<T>(this.comp, this.empty, false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.addIfNotPresent(item).add(item, ctx);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    private Worklist<T> addIfNotPresent(T item) {
        Worklist<T> retval = this.map.get(item);
        if (retval == null) {
            retval = this.empty.newInstance();
            this.map.put(item, retval);
        }
        return retval;
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        Map.Entry<T, Worklist<T>> entry = this.map.firstEntry();
        if (entry == null) {
            return null;
        }
        T retval = entry.getValue().poll(ctx);
        if (entry.getValue().isEmpty()) {
            this.map.pollFirstEntry();
        }
        if (retval != null) {
            --this.size;
        }
        return retval;
    }

    @Override
    public T peek() {
        Map.Entry<T, Worklist<T>> entry = this.map.firstEntry();
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Comparator<T> getComparator() {
        if (this.innerComp == null) {
            return this.comp;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                int r = Ordered.this.comp.compare(arg0, arg1);
                if (r == 0) {
                    return Ordered.this.innerComp.compare(arg0, arg1);
                }
                return r;
            }
        };
    }

    @Override
    public void finishAddInitial() {
    }
}

