/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.Maker;
import galois.runtime.wl.Worklist;

class LocalWorklist<T>
implements Worklist<T> {
    private Worklist<T> outer;
    private Worklist<T>[] inner;

    public LocalWorklist(Maker<T> outerMaker, Maker<T> innerMaker) {
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.inner = new Worklist[numThreads];
        int i = 0;
        while (i < numThreads) {
            this.inner[i] = innerMaker.make();
            ++i;
        }
        this.outer = outerMaker.make();
    }

    @Override
    public Worklist<T> newInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.inner[ctx.getThreadId()].add(item, ctx);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.outer.add(item, ctx);
    }

    @Override
    public boolean isEmpty() {
        return this.outer.isEmpty();
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = this.inner[ctx.getThreadId()].poll(ctx);
        if (retval == null) {
            retval = this.outer.poll(ctx);
        }
        return retval;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
        this.outer.finishAddInitial();
    }
}

