/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

class CsnziReadWriteLock
implements ReadWriteLock {
    private final AtomicReference<Node> tail;
    private final AtomicInteger threadId = new AtomicInteger();
    private final ThreadLocal<LocalState> localState;

    public CsnziReadWriteLock(int numThreads) {
        this.tail = new AtomicReference();
        final ReadNode[] rNodes = new ReadNode[numThreads];
        int i = 0;
        while (i < numThreads) {
            rNodes[i] = new ReadNode(numThreads);
            ++i;
        }
        i = 0;
        while (i < numThreads) {
            rNodes[i].next = rNodes[(i + 1) % numThreads];
            ++i;
        }
        this.localState = new ThreadLocal<LocalState>(){

            @Override
            protected LocalState initialValue() {
                int id = CsnziReadWriteLock.this.threadId.getAndIncrement();
                return new LocalState(id, rNodes[id]);
            }
        };
    }

    private ReadNode allocateReadNode(LocalState local) {
        ReadNode cur = local.rNode;
        while (cur.inUse.get() || !cur.inUse.compareAndSet(false, true)) {
            cur = (ReadNode)cur.next;
        }
        return cur;
    }

    private void freeReadNode(ReadNode rNode) {
        rNode.inUse.set(false);
    }

    @Override
    public Lock readLock() {
        return new ReadLock();
    }

    @Override
    public Lock writeLock() {
        return new WriteLock();
    }

    private static final class Csnzi {
        private CsnziRootNode root = new CsnziRootNode();
        private final CsnziLeafNode[] leaves;

        public Csnzi(int numThreads) {
            this.leaves = new CsnziLeafNode[numThreads];
            int i = 0;
            while (i < numThreads) {
                this.leaves[i] = new CsnziLeafNode(this.root);
                ++i;
            }
        }

        public CsnziNode arrive(int id) {
            block3: {
                do {
                    if (!this.root.isOpen()) {
                        return null;
                    }
                    if (!this.shouldArriveAtRoot()) break block3;
                } while (!this.root.tryIncrement());
                return this.root;
            }
            CsnziLeafNode leaf = this.getLeafNode(id);
            if (leaf.arrive()) {
                return leaf;
            }
            return null;
        }

        public boolean depart(CsnziNode node) {
            return node.depart();
        }

        private boolean shouldArriveAtRoot() {
            return false;
        }

        private CsnziLeafNode getLeafNode(int id) {
            return this.leaves[id];
        }

        public void open() {
            this.root.open(0, false);
        }

        public void open(int arrivals, boolean closed) {
            this.root.open(arrivals, closed);
        }

        public boolean isOpened() {
            return this.root.isOpen();
        }

        public boolean close() {
            return this.root.close();
        }

        public boolean closeIfEmpty() {
            return this.root.closeIfEmpty();
        }
    }

    private static final class CsnziLeafNode
    extends CsnziNode {
        private final AtomicInteger count;
        private final CsnziNode parent;

        public CsnziLeafNode(CsnziNode parent) {
            this.parent = parent;
            this.count = new AtomicInteger();
        }

        @Override
        public boolean arrive() {
            int value;
            boolean arrivedAtParent = false;
            do {
                if ((value = this.count.get()) != 0 || arrivedAtParent) continue;
                if (this.parent.arrive()) {
                    arrivedAtParent = true;
                    continue;
                }
                return false;
            } while (!this.count.compareAndSet(value, value + 1));
            if (arrivedAtParent && value != 0) {
                this.parent.depart();
            }
            return true;
        }

        @Override
        public boolean depart() {
            int value;
            while (!this.count.compareAndSet(value = this.count.get(), value - 1)) {
            }
            if (value == 1) {
                return this.parent.depart();
            }
            return true;
        }
    }

    private static abstract class CsnziNode {
        private CsnziNode() {
        }

        public abstract boolean arrive();

        public abstract boolean depart();
    }

    private static final class CsnziRootNode
    extends CsnziNode {
        private static final int CLOSED = 1;
        private static final int OPENED = 0;
        private final AtomicInteger state = new AtomicInteger();

        public boolean tryIncrement() {
            int value = this.state.get();
            return this.state.compareAndSet(value, value + 2);
        }

        @Override
        public boolean arrive() {
            int value;
            do {
                if ((value = this.state.get()) != 1) continue;
                return false;
            } while (!this.state.compareAndSet(value, value + 2));
            return true;
        }

        @Override
        public boolean depart() {
            int value;
            while (!this.state.compareAndSet(value = this.state.get(), value - 2)) {
            }
            return value - 2 != 1;
        }

        public boolean isOpen() {
            return (this.state.get() & 1) == 0;
        }

        public void open(int count, boolean closed) {
            if (closed) {
                this.state.set(count << 1 | 1);
            } else {
                this.state.set(count << 1);
            }
        }

        public boolean close() {
            int newValue;
            int value;
            do {
                if (((value = this.state.get()) & 1) == 0) continue;
                return false;
            } while (!this.state.compareAndSet(value, newValue = value | 1));
            return newValue == 1;
        }

        public boolean closeIfEmpty() {
            int value;
            do {
                if ((value = this.state.get()) == 0) continue;
                return false;
            } while (!this.state.compareAndSet(value, 1));
            return true;
        }
    }

    private static final class LocalState {
        private final int threadId;
        final ReadNode rNode;
        final WriteNode wNode;
        Node departFrom;
        CsnziNode ticket;

        public LocalState(int threadId, ReadNode rNode) {
            this.threadId = threadId;
            this.rNode = rNode;
            this.wNode = new WriteNode();
        }
    }

    private static abstract class Node {
        volatile boolean spin;
        volatile Node qNext;

        private Node() {
        }
    }

    private class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            Node t;
            ReadNode rNode = null;
            LocalState local = (LocalState)CsnziReadWriteLock.this.localState.get();
            while (true) {
                if ((t = (Node)CsnziReadWriteLock.this.tail.get()) == null) {
                    if (rNode == null) {
                        rNode = CsnziReadWriteLock.this.allocateReadNode(local);
                    }
                    rNode.spin = false;
                    if (!CsnziReadWriteLock.this.tail.compareAndSet(null, rNode)) continue;
                    rNode.csnzi.open();
                    local.ticket = rNode.csnzi.arrive(local.threadId);
                    if (local.ticket != null) {
                        local.departFrom = rNode;
                        return;
                    }
                    rNode = null;
                    continue;
                }
                if (t instanceof WriteNode) {
                    if (rNode == null) {
                        rNode = CsnziReadWriteLock.this.allocateReadNode(local);
                    }
                    rNode.spin = true;
                    if (!CsnziReadWriteLock.this.tail.compareAndSet(t, rNode)) continue;
                    t.qNext = rNode;
                    local.ticket = rNode.csnzi.arrive(local.threadId);
                    if (local.ticket != null) {
                        local.departFrom = rNode;
                        while (rNode.spin) {
                        }
                        return;
                    }
                    rNode = null;
                    continue;
                }
                local.ticket = ((ReadNode)t).csnzi.arrive(local.threadId);
                if (local.ticket != null) break;
            }
            if (rNode != null) {
                CsnziReadWriteLock.this.freeReadNode(rNode);
            }
            local.departFrom = t;
            while (t.spin) {
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            LocalState local = (LocalState)CsnziReadWriteLock.this.localState.get();
            ReadNode rNode = (ReadNode)local.departFrom;
            if (rNode.csnzi.depart(local.ticket)) {
                return;
            }
            rNode.qNext.spin = false;
            rNode.qNext = null;
            CsnziReadWriteLock.this.freeReadNode(rNode);
        }
    }

    private static final class ReadNode
    extends Node {
        Csnzi csnzi;
        Node next;
        AtomicBoolean inUse;

        public ReadNode(int numThreads) {
            this.csnzi = new Csnzi(numThreads);
            this.inUse = new AtomicBoolean();
        }
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            LocalState local = (LocalState)CsnziReadWriteLock.this.localState.get();
            Node t = CsnziReadWriteLock.this.tail.getAndSet(local.wNode);
            if (t != null) {
                local.wNode.spin = true;
                t.qNext = local.wNode;
                if (t instanceof WriteNode) {
                    while (local.wNode.spin) {
                    }
                } else {
                    ReadNode rNode = (ReadNode)t;
                    while (!rNode.csnzi.isOpened()) {
                    }
                    if (rNode.csnzi.close()) {
                        while (t.spin) {
                        }
                        CsnziReadWriteLock.this.freeReadNode(rNode);
                    } else {
                        while (local.wNode.spin) {
                        }
                    }
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            LocalState local = (LocalState)CsnziReadWriteLock.this.localState.get();
            if (local.wNode.qNext == null) {
                if (CsnziReadWriteLock.this.tail.compareAndSet(local.wNode, null)) {
                    return;
                }
                while (local.wNode.qNext == null) {
                }
            }
            local.wNode.qNext.spin = false;
            local.wNode.qNext = null;
        }
    }

    private static final class WriteNode
    extends Node {
        private WriteNode() {
        }
    }
}

