/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentRandomPermutation.class)
@MatchingLeafVersion(value=ConcurrentRandomPermutation.class)
class ConcurrentRandomPermutation<T>
implements Worklist<T> {
    private static final int chunkSize = 2 * GaloisRuntime.getRuntime().getMaxThreads();
    private final List<T> items = new ArrayList<T>();
    private final Deque<T>[] inner;
    private final AtomicInteger cur = new AtomicInteger();
    private AtomicInteger size;

    public ConcurrentRandomPermutation(Maker<Integer> maker, boolean needSize) {
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.inner = new Deque[numThreads];
        int i = 0;
        while (i < numThreads) {
            this.inner[i] = new ArrayDeque<T>();
            ++i;
        }
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentRandomPermutation<T>(null, false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.inner[ctx.getThreadId()].add(item);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.items.add(item);
    }

    @Override
    public void finishAddInitial() {
        Collections.shuffle(this.items);
        this.cur.set(this.items.size());
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        T retval = this.inner[tid].poll();
        if (retval == null) {
            int bottom = this.cur.addAndGet(-chunkSize);
            int top = bottom + chunkSize - 1;
            if (top >= 0) {
                retval = this.items.get(top);
            }
            int cur = Math.max(bottom, 0);
            while (cur < top) {
                this.inner[tid].add(this.items.get(cur));
                ++cur;
            }
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.cur.get() < 0;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }
}

