/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentOrderedLeaf;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NeedsSize;
import galois.runtime.wl.OrderableWorklist;
import galois.runtime.wl.Worklist;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@NeedsSize
@MatchingLeafVersion(value=ConcurrentOrderedLeaf.class)
@MatchingConcurrentVersion(value=ConcurrentOrdered.class)
class ConcurrentOrdered<T>
implements OrderableWorklist<T> {
    private final Worklist<T> empty;
    private final ConcurrentSkipListMap<T, Worklist<T>> map;
    private final Comparator<T> comp;
    private final Comparator<T> innerComp;
    private final Lock readRootLock;
    private final Lock writeRootLock;
    private final AtomicInteger sizeLock;
    private AtomicInteger size;

    public ConcurrentOrdered(Comparator<T> comp, Maker<T> maker, boolean needSize) {
        this(comp, maker.make(), needSize);
    }

    private ConcurrentOrdered(Comparator<T> comp, Worklist<T> empty, boolean needSize) {
        this.comp = comp;
        this.empty = empty;
        this.map = new ConcurrentSkipListMap(comp);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readRootLock = lock.readLock();
        this.writeRootLock = lock.writeLock();
        this.sizeLock = new AtomicInteger();
        this.innerComp = empty instanceof OrderableWorklist ? ((OrderableWorklist)empty).getComparator() : null;
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentOrdered<T>(this.comp, this.empty, this.size != null);
    }

    private void addExclusive(ForeachContext<T> ctx, T item) {
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.addIfNotPresent(item).add(item, ctx);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.readRootLock.lock();
        try {
            if (this.comp.compare(item, this.map.firstKey()) >= 0) {
                if (this.size != null) {
                    this.size.incrementAndGet();
                }
                this.addIfNotPresent(item).add(item, ctx);
                return;
            }
        }
        catch (NoSuchElementException e) {
            if (this.size != null) {
                this.size.incrementAndGet();
            }
            this.addIfNotPresent(item).add(item, ctx);
            return;
        }
        finally {
            this.readRootLock.unlock();
        }
        this.addExclusive(ctx, item);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    private Worklist<T> addIfNotPresent(T item) {
        Worklist<T> retval = this.map.get(item);
        if (retval == null) {
            Worklist<T> nextWorklist;
            try {
                nextWorklist = this.empty.newInstance();
            }
            catch (Exception e) {
                throw new Error(e);
            }
            Worklist<T> prevWorklist = this.map.putIfAbsent(item, nextWorklist);
            retval = prevWorklist == null ? nextWorklist : prevWorklist;
        }
        return retval;
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        block11: {
            this.readRootLock.lock();
            try {
                T retval;
                Map.Entry<T, Worklist<T>> entry = this.map.firstEntry();
                if (entry == null) {
                    return null;
                }
                try {
                    int readers = this.sizeLock.incrementAndGet();
                    if (readers <= 0 || entry.getValue().size() <= readers + 1) break block11;
                    retval = entry.getValue().poll(ctx);
                }
                finally {
                    this.sizeLock.decrementAndGet();
                }
                if (this.size != null && retval != null) {
                    this.size.decrementAndGet();
                }
                T t = retval;
                return t;
            }
            finally {
                this.readRootLock.unlock();
            }
        }
        return this.pollExclusive(ctx);
    }

    private T pollExclusive(ForeachContext<T> ctx) {
        this.writeRootLock.lock();
        try {
            Map.Entry<T, Worklist<T>> entry = this.map.firstEntry();
            if (entry == null) {
                return null;
            }
            T retval = entry.getValue().poll(ctx);
            if (entry.getValue().isEmpty()) {
                this.map.pollFirstEntry();
            }
            if (this.size != null && retval != null) {
                this.size.decrementAndGet();
            }
            T t = retval;
            return t;
        }
        finally {
            this.writeRootLock.unlock();
        }
    }

    @Override
    public T peek() {
        Map.Entry<T, Worklist<T>> entry = this.map.firstEntry();
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public boolean isEmpty() {
        if (this.size != null) {
            return this.size.get() == 0;
        }
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<T> getComparator() {
        if (this.innerComp == null) {
            return this.comp;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                int r = ConcurrentOrdered.this.comp.compare(arg0, arg1);
                if (r == 0) {
                    return ConcurrentOrdered.this.innerComp.compare(arg0, arg1);
                }
                return r;
            }
        };
    }

    @Override
    public void finishAddInitial() {
    }
}

