/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentFIFO.class)
@MatchingLeafVersion(value=ConcurrentFIFO.class)
class ConcurrentFIFO<T>
implements Worklist<T> {
    private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private AtomicInteger size;

    public ConcurrentFIFO(Maker<T> maker, boolean needSize) {
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentFIFO<T>(null, this.size != null);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        if (this.queue.add(item) && this.size != null) {
            this.size.incrementAndGet();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = this.queue.poll();
        if (this.size != null && retval != null) {
            this.size.decrementAndGet();
        }
        return retval;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
    }
}

