/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.wl.ConcurrentChunkedLIFOLeaf;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.NestedAreSerial;
import galois.runtime.wl.Worklist;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@NestedAreSerial
@MatchingConcurrentVersion(value=ConcurrentChunkedLIFO.class)
@MatchingLeafVersion(value=ConcurrentChunkedLIFOLeaf.class)
class ConcurrentChunkedLIFO<T>
implements Worklist<T> {
    private static final int CACHE_MULTIPLE = 16;
    private final int chunkSize;
    private Worklist<T>[] current;
    private final AtomicReference<Node<T>> head;
    private AtomicInteger size;

    public ConcurrentChunkedLIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public ConcurrentChunkedLIFO(int chunkSize, Maker<T> maker, boolean needSize) {
        this(chunkSize, (Worklist<T>[])null, needSize);
        int numThreads = GaloisRuntime.getRuntime().getMaxThreads();
        this.current = new Worklist[numThreads * 16];
        int i = 0;
        while (i < numThreads) {
            this.current[super.getIndex((int)i)] = maker.make();
            ++i;
        }
    }

    private ConcurrentChunkedLIFO(int chunkSize, Worklist<T>[] current, boolean needSize) {
        this.chunkSize = chunkSize;
        this.current = current;
        this.head = new AtomicReference();
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        int numThreads = this.current.length / 16;
        Worklist[] c = new Worklist[numThreads * 16];
        int i = 0;
        while (i < numThreads) {
            c[this.getIndex((int)i)] = this.current[this.getIndex(i)].newInstance();
            ++i;
        }
        return new ConcurrentChunkedLIFO<T>(this.chunkSize, c, this.size != null);
    }

    private int getIndex(int tid) {
        return tid * 16;
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        Worklist<T> c = this.current[this.getIndex(tid)];
        c.add(item, ctx);
        if (c.size() >= this.chunkSize) {
            this.addInternal(c);
            this.current[this.getIndex((int)tid)] = c.newInstance();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int tid = ctx.getThreadId();
        if (this.current[this.getIndex(tid)] == null) {
            this.current[this.getIndex((int)tid)] = this.pollInternal();
        }
        T retval = null;
        while (this.current[this.getIndex(tid)] != null) {
            retval = this.current[this.getIndex(tid)].poll(ctx);
            if (retval != null) break;
            this.current[this.getIndex((int)tid)] = this.pollInternal();
        }
        if (this.size != null && retval != null) {
            this.size.decrementAndGet();
        }
        return retval;
    }

    private void addInternal(Worklist<T> wl) {
        Node<T> cur;
        Node<T> next = new Node<T>(wl);
        do {
            cur = this.head.get();
            ((Node)next).next = (Node)cur;
        } while (!this.head.compareAndSet(cur, next));
    }

    private Worklist<T> pollInternal() {
        Node next;
        Node<T> cur;
        do {
            if ((cur = this.head.get()) != null) continue;
            return null;
        } while (!this.head.compareAndSet(cur, next = ((Node)cur).next));
        return ((Node)cur).wl;
    }

    @Override
    public boolean isEmpty() {
        if (this.size != null) {
            return this.size.get() == 0;
        }
        return this.head.get() == null;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
    }

    private static class Node<T> {
        private Node<T> next;
        private Worklist<T> wl;

        public Node(Worklist<T> wl) {
            this.wl = wl;
        }
    }
}

