/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.objects.Counter;
import galois.objects.CounterToSuspendWithBuilder;
import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentBulkSynchronousLeaf;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.Worklist;
import java.util.concurrent.atomic.AtomicInteger;
import util.fn.LambdaVoid;

@MatchingConcurrentVersion(value=ConcurrentBulkSynchronous.class)
@MatchingLeafVersion(value=ConcurrentBulkSynchronousLeaf.class)
class ConcurrentBulkSynchronous<T>
implements Worklist<T> {
    private Worklist<T> current;
    private Worklist<T> next;
    private boolean isEmpty;
    private final Counter<T> counter;
    private AtomicInteger size;

    public ConcurrentBulkSynchronous(Maker<T> m, boolean needSize) {
        this(m.make(), m.make(), needSize);
    }

    private ConcurrentBulkSynchronous(Worklist<T> c, Worklist<T> n, boolean needSize) {
        this.current = c;
        this.next = n;
        this.counter = new CounterToSuspendWithBuilder().create(1, false, new LambdaVoid<ForeachContext<T>>(){

            @Override
            public void call(ForeachContext<T> x) {
                if (ConcurrentBulkSynchronous.this.next.isEmpty()) {
                    ConcurrentBulkSynchronous.this.isEmpty = true;
                } else {
                    Worklist t = ConcurrentBulkSynchronous.this.current;
                    ConcurrentBulkSynchronous.this.current = ConcurrentBulkSynchronous.this.next;
                    ConcurrentBulkSynchronous.this.next = t;
                }
            }
        });
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentBulkSynchronous<T>(this.current.newInstance(), this.next.newInstance(), this.size != null);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        if (this.size != null) {
            this.size.incrementAndGet();
        }
        this.isEmpty = false;
        this.next.add(item, ctx);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = this.current.poll(ctx);
        if (retval == null && !this.isEmpty) {
            this.counter.increment(ctx);
        }
        if (this.size != null && retval != null) {
            this.size.decrementAndGet();
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        if (this.size != null) {
            return this.size.get() == 0;
        }
        return this.isEmpty;
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishAddInitial() {
    }
}

