/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;
import java.util.concurrent.atomic.AtomicInteger;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentBoundedFIFO.class)
@MatchingLeafVersion(value=ConcurrentBoundedFIFO.class)
class ConcurrentBoundedFIFO<T>
implements Worklist<T> {
    private final Object[] buffer;
    private final AtomicInteger widx;
    private int ridx;
    private final int mask;
    private AtomicInteger size;

    public ConcurrentBoundedFIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public ConcurrentBoundedFIFO(int maxElements, Maker<T> maker, boolean needSize) {
        int logMax = 32 - Integer.numberOfLeadingZeros(maxElements - 1);
        this.mask = (1 << logMax) - 1;
        this.buffer = new Object[1 << logMax];
        this.widx = new AtomicInteger();
        this.ridx = 0;
        if (needSize) {
            this.size = new AtomicInteger();
        }
    }

    @Override
    public Worklist<T> newInstance() {
        return new ConcurrentBoundedFIFO<T>(this.buffer.length, null, this.size != null);
    }

    @Override
    public boolean isEmpty() {
        return (this.ridx & this.mask) == (this.widx.get() & this.mask);
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size.get();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.buffer[this.widx.getAndIncrement() & this.mask] = item;
        if (this.size != null) {
            this.size.incrementAndGet();
        }
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        int index = this.ridx & this.mask;
        Object v = null;
        do {
            if (!this.isEmpty()) continue;
            return null;
        } while ((v = this.buffer[index]) == null);
        this.buffer[index] = null;
        ++this.ridx;
        if (this.size != null) {
            this.size.decrementAndGet();
        }
        return (T)v;
    }

    @Override
    public void finishAddInitial() {
    }
}

