/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.BulkSynchronousLeaf;
import galois.runtime.wl.ConcurrentBulkSynchronous;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.Worklist;

@MatchingLeafVersion(value=BulkSynchronousLeaf.class)
@MatchingConcurrentVersion(value=ConcurrentBulkSynchronous.class)
public class BulkSynchronous<T>
implements Worklist<T> {
    private Worklist<T> current;
    private Worklist<T> next;
    private int size;

    public BulkSynchronous(Maker<T> maker, boolean needSize) {
        this(maker.make(), maker.make(), needSize);
    }

    private BulkSynchronous(Worklist<T> current, Worklist<T> next, boolean needSize) {
        this.current = current;
        this.next = next;
        this.size = 0;
    }

    @Override
    public Worklist<T> newInstance() {
        return new BulkSynchronous<T>(this.current.newInstance(), this.next.newInstance(), false);
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        ++this.size;
        this.next.add(item, ctx);
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        T retval = this.current.poll(ctx);
        if (retval == null && (retval = this.next.poll(ctx)) != null) {
            this.current = this.next;
            this.next = this.next.newInstance();
        }
        if (retval != null) {
            --this.size;
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void finishAddInitial() {
    }
}

