/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime.wl;

import galois.runtime.ForeachContext;
import galois.runtime.wl.ConcurrentBoundedFIFO;
import galois.runtime.wl.Maker;
import galois.runtime.wl.MatchingConcurrentVersion;
import galois.runtime.wl.MatchingLeafVersion;
import galois.runtime.wl.OnlyLeaf;
import galois.runtime.wl.Worklist;

@OnlyLeaf
@MatchingConcurrentVersion(value=ConcurrentBoundedFIFO.class)
@MatchingLeafVersion(value=BoundedFIFO.class)
public class BoundedFIFO<T>
implements Worklist<T> {
    public static final int DEFAULT_MAX_ELEMENTS = 32;
    private final Object[] buffer;
    private int widx;
    private int ridx;
    private int size;

    public BoundedFIFO(Maker<T> maker, boolean needSize) {
        this(32, maker, needSize);
    }

    public BoundedFIFO(int maxElements, Maker<T> maker, boolean needSize) {
        this.buffer = new Object[maxElements];
        this.widx = 0;
        this.ridx = 0;
    }

    @Override
    public Worklist<T> newInstance() {
        return new BoundedFIFO<T>(this.buffer.length, null, false);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(T item, ForeachContext<T> ctx) {
        this.buffer[this.widx] = item;
        if (++this.widx == this.buffer.length) {
            this.widx = 0;
        }
        ++this.size;
    }

    @Override
    public void addInitial(T item, ForeachContext<T> ctx) {
        this.add(item, ctx);
    }

    @Override
    public T poll(ForeachContext<T> ctx) {
        if (this.isEmpty()) {
            return null;
        }
        Object v = this.buffer[this.ridx];
        this.buffer[this.ridx] = null;
        if (++this.ridx == this.buffer.length) {
            this.ridx = 0;
        }
        --this.size;
        return (T)v;
    }

    @Override
    public void finishAddInitial() {
    }
}

