/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;

class ThreadPool {
    private final List<Worker> workers;
    private final List<Thread> threads;
    private List<? extends Callable<?>> callables;
    private final Semaphore start;
    private final Semaphore finish;
    private final int numThreads;
    private volatile boolean shutdown;

    public ThreadPool(int numThreads) {
        this.numThreads = numThreads;
        this.workers = new ArrayList<Worker>();
        this.threads = new ArrayList<Thread>();
        this.start = new Semaphore(0);
        this.finish = new Semaphore(0);
        int i = 0;
        while (i < numThreads) {
            Worker w = new Worker(i);
            Thread t = new Thread(w);
            t.setDaemon(true);
            this.threads.add(t);
            this.workers.add(w);
            t.start();
            ++i;
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.start.release(this.numThreads);
    }

    public void callAll(List<? extends Callable<?>> callables) throws InterruptedException, ExecutionException {
        this.callables = callables;
        this.start.release(this.numThreads);
        this.finish.acquire(this.numThreads);
        int i = 0;
        while (i < this.numThreads) {
            if (this.workers.get(i).error != null) {
                throw new ExecutionException(this.workers.get(i).error);
            }
            ++i;
        }
    }

    private class Worker
    implements Runnable {
        private final int id;
        private Throwable error;

        public Worker(int id) {
            this.id = id;
        }

        private void __stackSamplerRecordMe() throws Exception {
            ((Callable)ThreadPool.this.callables.get(this.id)).call();
        }

        @Override
        public void run() {
            while (!ThreadPool.this.shutdown) {
                try {
                    ThreadPool.this.start.acquire();
                    if (!ThreadPool.this.shutdown) {
                        this.__stackSamplerRecordMe();
                    }
                }
                catch (InterruptedException e) {
                    this.error = e;
                    ThreadPool.this.finish.release();
                    continue;
                }
                catch (Throwable e) {
                    try {
                        this.error = e;
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ThreadPool.this.finish.release();
                    }
                }
                ThreadPool.this.finish.release();
            }
        }
    }
}

