/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.Features;
import galois.runtime.ForeachContext;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.IterationStatistics;
import galois.runtime.ReleaseCallback;
import galois.runtime.WorkNotProgressiveException;
import galois.runtime.WorkNotUsefulException;
import galois.runtime.wl.Worklist;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import util.fn.Lambda2Void;

class SerialExecutor<T>
implements Executor,
ForeachContext<T> {
    private final Deque<Callback> suspendThunks = new ArrayDeque<Callback>();
    private boolean yield;
    private boolean finish;
    private Worklist<T> worklist;

    @Override
    public void onRelease(Iteration it, ReleaseCallback action) {
    }

    @Override
    public void onCommit(Iteration it, Callback call) {
        this.suspendThunks.addFirst(call);
        this.yield = true;
    }

    @Override
    public void onUndo(Iteration it, Callback action) {
    }

    public IterationStatistics call(Lambda2Void<T, ForeachContext<T>> body, Worklist<T> worklist) throws ExecutionException {
        this.worklist = worklist;
        int numCommitted = 0;
        do {
            T item;
            this.reset();
            while ((item = worklist.poll(this)) != null) {
                ++numCommitted;
                try {
                    body.call(item, this);
                }
                catch (WorkNotUsefulException workNotUsefulException) {
                }
                catch (WorkNotProgressiveException workNotProgressiveException) {
                    // empty catch block
                }
                Features.getReplayFeature().onCommit(null, this.getIterationId(), item);
                if (this.yield) break;
            }
            if (this.suspendThunks.isEmpty()) continue;
            try {
                for (Callback thunk : this.suspendThunks) {
                    thunk.call();
                }
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        } while (!this.finish && this.yield);
        IterationStatistics stats = new IterationStatistics();
        stats.putStats(Thread.currentThread(), numCommitted, 0);
        return stats;
    }

    private void reset() {
        this.finish = false;
        this.yield = false;
        this.suspendThunks.clear();
    }

    @Override
    public final void add(T t) {
        this.add(t, (byte)-1);
    }

    @Override
    public void add(T t, byte flags) {
        this.worklist.add(t, this);
    }

    @Override
    public void finish() {
        this.finish = true;
        this.yield = true;
    }

    @Override
    public int getThreadId() {
        return 0;
    }

    @Override
    public void suspendWith(Callback call) {
        this.suspendThunks.addFirst(call);
        this.yield = true;
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSerial() {
        return true;
    }

    @Override
    public void suspend(Callback listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendDone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterationId() {
        return 0;
    }
}

