/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.objects.Mappable;
import galois.runtime.AbstractExecutorContext;
import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.IterationStatistics;
import galois.runtime.MappableType;
import galois.runtime.ReleaseCallback;
import galois.runtime.ReplayFeature;
import galois.runtime.Replayable;
import galois.runtime.WorkNotProgressiveException;
import galois.runtime.WorkNotUsefulException;
import galois.runtime.wl.Worklist;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;
import util.fn.Lambda2Void;
import util.fn.LambdaVoid;

class PlaybackReplayFeature<T>
extends ReplayFeature
implements Executor,
ForeachContext<T> {
    private final TLongObjectHashMap<ReplayFeature.CallbackType> callbackTypes = new TLongObjectHashMap();
    private final TLongObjectHashMap<Object> callbacks = new TLongObjectHashMap();
    private final Deque<Callback> commitActions = new ArrayDeque<Callback>();
    private final ItemMap<T> map = new TroveItemMap();
    private ReplayFeature.Log log;
    private int cur;
    private int curLog;
    private int iterationId;

    public PlaybackReplayFeature(int maxIterations) {
        super(maxIterations);
    }

    @Override
    public void onRelease(Iteration it, ReleaseCallback action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onCommit(Iteration it, Callback origCall) {
        this.commitActions.addLast(origCall);
    }

    @Override
    public void onUndo(Iteration it, Callback action) {
    }

    @Override
    public boolean isSerial() {
        return true;
    }

    @Override
    public void suspend(Callback listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendDone() {
        throw new UnsupportedOperationException();
    }

    private void reset() {
        this.map.clear();
    }

    public IterationStatistics call(Lambda2Void<T, ForeachContext<T>> body, Worklist<T> worklist) throws ExecutionException {
        T item;
        this.reset();
        AbstractExecutorContext ctx = new AbstractExecutorContext<T>(){

            @Override
            public int getThreadId() {
                return 0;
            }
        };
        while ((item = worklist.poll(ctx)) != null) {
            this.map.update(this.getRid(item), item);
        }
        return this.run(body, null, null, new Object[0]);
    }

    public IterationStatistics call(Mappable<T> mappable, Object body, MappableType type, Object ... args) throws ExecutionException {
        this.reset();
        mappable.map(new LambdaVoid<T>(){

            @Override
            public void call(T item) {
                PlaybackReplayFeature.this.map.update(PlaybackReplayFeature.this.getRid(item), item);
            }
        });
        return this.run(null, body, type, args);
    }

    private IterationStatistics run(Lambda2Void<T, ForeachContext<T>> body, Object mappableBody, MappableType type, Object ... args) throws ExecutionException {
        T item;
        this.nextLog();
        int numCommitted = 0;
        while ((item = this.poll()) != null) {
            Callback c;
            ++numCommitted;
            try {
                if (body != null) {
                    body.call(item, this);
                } else {
                    type.call(mappableBody, item, args);
                }
            }
            catch (WorkNotUsefulException workNotUsefulException) {
            }
            catch (WorkNotProgressiveException workNotProgressiveException) {
                // empty catch block
            }
            if (this.commitActions.isEmpty()) continue;
            while ((c = this.commitActions.poll()) != null) {
                c.call();
            }
        }
        this.reset();
        IterationStatistics stats = new IterationStatistics();
        stats.putStats(Thread.currentThread(), numCommitted, 0);
        return stats;
    }

    @Override
    public void finish() {
    }

    @Override
    public void suspendWith(Callback call) {
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(T item) {
        this.add(item, (byte)-1);
    }

    @Override
    public void add(T item, byte flags) {
        this.map.update(this.getRid(item), item);
    }

    @Override
    public int getIterationId() {
        this.checkValidity();
        return this.iterationId;
    }

    @Override
    public int getThreadId() {
        return 0;
    }

    @Override
    public void onCommit(Iteration it, int iterationId, Object item) {
        this.checkValidity();
        throw new UnsupportedOperationException();
    }

    @Override
    public void onCallbackExecute(long rid) {
        this.checkValidity();
    }

    @Override
    public boolean isCallbackControlled() {
        this.checkValidity();
        return true;
    }

    private void nextLog() {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getLogName(this.curLog))));
            this.log = (ReplayFeature.Log)in.readObject();
            this.cur = 0;
            in.close();
            ++this.curLog;
        }
        catch (FileNotFoundException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
    }

    private T poll() throws ExecutionException {
        while (true) {
            if (this.cur < this.log.size()) {
                switch (this.log.getAction(this.cur)) {
                    case POLL: {
                        this.iterationId = this.log.getIterationId(this.cur);
                        long rid = this.log.getRid(this.cur++);
                        return this.map.poll(rid);
                    }
                    case CALLBACK: {
                        long rid = this.log.getRid(this.cur);
                        this.callCallback(rid, this);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                ++this.cur;
                continue;
            }
            if (this.cur != this.log.getCapacity()) break;
            this.nextLog();
        }
        return null;
    }

    @Override
    public void onCreateReplayable(Replayable item) {
        this.checkValidity();
        if (GaloisRuntime.getRuntime().inRoot()) {
            this.setNextRid(item);
        } else {
            this.setNextRid(null, this.iterationId, item);
        }
    }

    @Override
    public void onFinish() {
        this.checkValidity();
    }

    public <U> void registerCallback(long rid, LambdaVoid<ForeachContext<U>> callback) {
        this.checkValidity();
        this.callbackTypes.put(rid, (Object)ReplayFeature.CallbackType.LAMBDA_CONTEXT);
        this.callbacks.put(rid, callback);
    }

    @Override
    public void registerCallback(long rid, Callback callback) {
        this.checkValidity();
        this.callbackTypes.put(rid, (Object)ReplayFeature.CallbackType.CALLBACK);
        this.callbacks.put(rid, (Object)callback);
    }

    private void callCallback(long rid, final ForeachContext<?> ctx) throws ExecutionException {
        final Object obj = this.callbacks.get(rid);
        switch ((ReplayFeature.CallbackType)((Object)this.callbackTypes.get(rid))) {
            case CALLBACK: {
                GaloisRuntime.getRuntime().replaceWithRootContextAndCall((Callback)obj);
                break;
            }
            case LAMBDA_CONTEXT: {
                GaloisRuntime.getRuntime().replaceWithRootContextAndCall(new Callback(){

                    @Override
                    public void call() {
                        ((LambdaVoid)obj).call(ctx);
                    }
                });
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private static interface ItemMap<T> {
        public void update(long var1, T var3);

        public T poll(long var1);

        public void clear();
    }

    private static class TroveItemMap<T>
    implements ItemMap<T> {
        private final TLongObjectHashMap<T> map = new TLongObjectHashMap();
        private final TLongIntHashMap counts = new TLongIntHashMap();

        @Override
        public void update(long rid, T item) {
            if (this.map.containsKey(rid)) {
                this.counts.put(rid, this.counts.get(rid) + 1);
            } else {
                this.map.put(rid, item);
                this.counts.put(rid, 1);
            }
        }

        @Override
        public T poll(long rid) {
            Object retval;
            int num = this.counts.get(rid);
            if (num == 1) {
                this.counts.remove(rid);
                retval = this.map.remove(rid);
            } else {
                this.counts.put(rid, num - 1);
                retval = this.map.get(rid);
            }
            assert (retval != null) : String.format("retval null for rid=%d, num=%d\n", rid, num);
            return (T)retval;
        }

        @Override
        public void clear() {
            this.map.clear();
            this.counts.clear();
        }
    }
}

