/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.AbstractParameterExecutor;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.MappableType;
import galois.runtime.ParameterStatistics;
import galois.runtime.WorkNotUsefulException;
import galois.runtime.wl.ParameterUnorderedWorklist;
import galois.runtime.wl.ParameterWorklist;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

class ParameterUnorderedExecutor<T>
extends AbstractParameterExecutor<T, T> {
    private AbstractParameterExecutor.StepRecord<Iteration> currStepRec = new AbstractParameterExecutor.StepRecord();
    private int numCommitted;
    private final ParameterUnorderedWorklist<T> worklist;
    private Object mappableBody;
    private MappableType type;
    private Object[] args;
    protected final List<Iteration> commitPool;

    public ParameterUnorderedExecutor(ParameterUnorderedWorklist<T> worklist) {
        this.worklist = worklist;
        this.commitPool = new ArrayList<Iteration>();
    }

    public ParameterStatistics call(Object body, MappableType type, Object ... args) throws ExecutionException {
        this.mappableBody = body;
        this.type = type;
        this.args = args;
        ParameterStatistics stats = this.call(null);
        this.mappableBody = null;
        this.type = null;
        this.args = null;
        return stats;
    }

    @Override
    public final void add(T t) {
        this.add(t, (byte)-1);
    }

    @Override
    public void add(T t, byte flags) {
        this.worklist.add(t);
    }

    @Override
    protected Iteration newIteration() {
        return new Iteration(this.getIterationId());
    }

    @Override
    protected ParameterWorklist<T, T> getWorklist() {
        return this.worklist;
    }

    @Override
    public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        IterationAbortException.throwException();
    }

    @Override
    protected boolean usingEagerOutput() {
        return true;
    }

    @Override
    protected void initTimeStep() {
        this.currStepRec.logWlSize(this.worklist.size());
        this.numCommitted = 0;
    }

    @Override
    protected void finishTimeStep() {
    }

    @Override
    protected int commitAll() {
        int numCommits = 0;
        for (Iteration it : this.commitPool) {
            Iteration.setCurrentIteration(it);
            int locksHeld = it.performCommit(true);
            this.currStepRec.logNeighSize(locksHeld);
            ++numCommits;
        }
        this.commitPool.clear();
        return numCommits;
    }

    @Override
    protected void run(T cur, Iteration it) {
        try {
            boolean notUsefull = false;
            try {
                if (this.mappableBody != null) {
                    this.type.call(this.mappableBody, cur, this.args);
                } else {
                    this.runBody(cur, it);
                }
            }
            catch (WorkNotUsefulException e) {
                notUsefull = true;
            }
            ++this.numCommitted;
            if (parameterCommittedLimit > 0 && this.numCommitted >= parameterCommittedLimit) {
                this.worklist.deferRemainingItems();
            }
            this.commitPool.add(it);
            this.currStepRec.logExecuted(it, notUsefull);
        }
        catch (IterationAbortException e) {
            it.performAbort();
            this.worklist.defer(cur);
        }
    }

    @Override
    protected void logStats() {
        this.dumpStepStats(this.currStepRec);
        this.currStepRec.clear();
    }

    @Override
    protected void finishLoop() {
    }
}

