/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.runtime.IterationStatistics;
import gnu.trove.TFloatCollection;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.PrintStream;
import java.util.List;

class ParameterStatistics
extends IterationStatistics {
    private final TIntArrayList neighMins;
    private final TIntArrayList neighMaxs;
    private final TFloatArrayList neighAves;
    private final TFloatArrayList neighStdevs;
    private final TIntArrayList notUsefulSize;
    private final TIntArrayList parallelWork = new TIntArrayList();
    private final TIntArrayList worklistSize = new TIntArrayList();

    public ParameterStatistics() {
        this.notUsefulSize = new TIntArrayList();
        this.neighAves = new TFloatArrayList();
        this.neighStdevs = new TFloatArrayList();
        this.neighMaxs = new TIntArrayList();
        this.neighMins = new TIntArrayList();
    }

    public void putStats(Thread thread, int parallelWork, int worklistSize, int notUsefulSize, List<Integer> ns) {
        super.putStats(thread, parallelWork, 0);
        this.parallelWork.add(parallelWork);
        this.worklistSize.add(worklistSize);
        this.notUsefulSize.add(notUsefulSize);
        float[] stats = this.summarizeInts(ns, 0);
        if (stats != null) {
            this.neighAves.add(stats[0]);
            this.neighMins.add((int)stats[1]);
            this.neighMaxs.add((int)stats[2]);
            this.neighStdevs.add((float)Math.sqrt(stats[3]));
        } else {
            this.neighAves.add(0.0f);
            this.neighMins.add(0);
            this.neighMaxs.add(0);
            this.neighStdevs.add(0.0f);
        }
    }

    @Override
    public void dumpFull(PrintStream out) {
        this.printFullHeader(out, "Begin Parameter Statistics");
        out.append("Active Nodes,Worklist Size,Not Useful Work Size,");
        out.append("Ave Neigh,Min Neigh,Max Neigh,Stdev Neigh\n");
        int i = 0;
        while (i < this.parallelWork.size()) {
            out.append(String.format("%s,%s,%s,%s,%s,%s,%s\n", this.parallelWork.get(i), this.worklistSize.get(i), this.notUsefulSize.get(i), Float.valueOf(this.neighAves.get(i)), this.neighMins.get(i), this.neighMaxs.get(i), Float.valueOf(this.neighStdevs.get(i))));
            ++i;
        }
        this.printFullHeader(out, "End Parameter Statistics");
    }

    @Override
    public void merge(Object obj) {
        super.merge(obj);
        ParameterStatistics other = (ParameterStatistics)obj;
        this.parallelWork.addAll((TIntCollection)other.parallelWork);
        this.worklistSize.addAll((TIntCollection)other.worklistSize);
        this.notUsefulSize.addAll((TIntCollection)other.notUsefulSize);
        this.neighAves.addAll((TFloatCollection)other.neighAves);
        this.neighMins.addAll((TIntCollection)other.neighMins);
        this.neighMaxs.addAll((TIntCollection)other.neighMaxs);
        this.neighStdevs.addAll((TFloatCollection)other.neighStdevs);
    }

    @Override
    public void dumpSummary(PrintStream out) {
        this.printSummaryHeader(out, "Parameter");
        int committed = this.getNumCommitted();
        int workDepth = this.parallelWork.size();
        out.printf("Committed: %d Critial Path Length: %d Average Parallelism: %.4f\n", committed, workDepth, Float.valueOf((float)committed / (float)workDepth));
    }
}

