/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.CollectionMath;
import util.Pair;
import util.Statistics;
import util.fn.FnIterable;
import util.fn.Lambda;

class IterationStatistics
extends Statistics {
    private final Map<Thread, Integer> committed = new HashMap<Thread, Integer>();
    private final Map<Thread, Integer> aborted = new HashMap<Thread, Integer>();

    @Override
    public void dumpFull(PrintStream out) {
        this.printFullHeader(out, "Iterations");
        Collection<Integer> total = this.total();
        Collection<Integer> c = this.committed.values();
        Collection<Float> abortRatio = this.abortRatio(total);
        int sumCommitted = CollectionMath.sumInteger(c);
        int sumTotal = CollectionMath.sumInteger(total);
        float sumAbortRatio = sumTotal != 0 ? (float)(sumTotal - sumCommitted) / (float)sumTotal : 0.0f;
        out.printf("Committed Iterations: %d per thread: %s\n", sumCommitted, c);
        this.summarizeInts(out, total, "\t");
        out.printf("Total Iterations: %d per thread: %s\n", sumTotal, total);
        this.summarizeInts(out, total, "\t");
        out.printf("Abort ratio: %.4f per thread: %s\n", Float.valueOf(sumAbortRatio), abortRatio);
        this.summarizeFloats(out, abortRatio, "\t");
    }

    private Collection<Float> abortRatio(Collection<Integer> total) {
        List<Float> abortRatio = FnIterable.from(this.aborted.values()).zip(FnIterable.from(total)).map(new Lambda<Pair<Integer, Integer>, Float>(){

            @Override
            public Float call(Pair<Integer, Integer> x) {
                return Float.valueOf(x.getSecond() != 0 ? (float)x.getFirst().intValue() / (float)x.getSecond().intValue() : 0.0f);
            }
        }).toList();
        return abortRatio;
    }

    private Collection<Integer> total() {
        Collection<Integer> total = CollectionMath.sumInteger(this.committed.values(), this.aborted.values());
        return total;
    }

    @Override
    public void dumpSummary(PrintStream out) {
        int total = CollectionMath.sumInteger(this.total());
        float abortRatio = total == 0 ? 0.0f : (float)CollectionMath.sumInteger(this.aborted.values()).intValue() / (float)total;
        this.printSummaryHeader(out, "Iterations");
        out.printf("Committed: %d Total: %d Abort Ratio: %.4f\n", CollectionMath.sumInteger(this.committed.values()), total, Float.valueOf(abortRatio));
    }

    public void putStats(Thread thread, int numCommitted, int numAborted) {
        Integer n = this.committed.get(thread);
        if (n == null) {
            this.committed.put(thread, numCommitted);
        } else {
            this.committed.put(thread, numCommitted + n);
        }
        n = this.aborted.get(thread);
        if (n == null) {
            this.aborted.put(thread, numAborted);
        } else {
            this.aborted.put(thread, numAborted + n);
        }
    }

    public int getNumCommitted() {
        return CollectionMath.sumInteger(this.committed.values());
    }

    private static <K> void mergeMap(Map<K, Integer> dst, Map<K, Integer> src) {
        for (Map.Entry<K, Integer> entry : src.entrySet()) {
            K k = entry.getKey();
            Integer v = dst.get(k);
            if (v == null) {
                dst.put(k, entry.getValue());
                continue;
            }
            dst.put(k, v + entry.getValue());
        }
    }

    @Override
    public void merge(Object obj) {
        IterationStatistics other = (IterationStatistics)obj;
        IterationStatistics.mergeMap(this.aborted, other.aborted);
        IterationStatistics.mergeMap(this.committed, other.committed);
    }
}

