/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.objects.Lockable;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.ReleaseCallback;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class Iteration {
    private static ThreadLocal<Iteration> iteration = new ThreadLocal();
    private final Deque<Callback> commitActions;
    private final List<ReleaseCallback> releaseActions;
    private final Deque<Callback> undoActions;
    private final List<Lockable> locked;
    private final int id;

    public Iteration(int id) {
        this.id = id;
        this.undoActions = new ArrayDeque<Callback>();
        this.releaseActions = new ArrayList<ReleaseCallback>();
        this.commitActions = new ArrayDeque<Callback>();
        this.locked = new ArrayList<Lockable>();
    }

    protected void reset() {
    }

    public static Iteration getCurrentIteration() {
        return iteration.get();
    }

    static void setCurrentIteration(Iteration it) {
        iteration.set(it);
    }

    public static Iteration acquire(Lockable lockable, byte flags) {
        Iteration it = null;
        if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
            it = Iteration.getCurrentIteration();
            it.acquire(lockable);
        }
        return it;
    }

    /*
     * Unable to fully structure code
     */
    public void acquire(Lockable lockable) {
        owner = lockable.getOwner();
        if (owner.get() != this) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            GaloisRuntime.getRuntime().raiseConflict(this, owner.get());
lbl5:
            // 2 sources

            ** while (!owner.compareAndSet(null, (Iteration)this))
        }
lbl6:
        // 1 sources

        this.locked.add(lockable);
    }

    void addCommitAction(Callback c) {
        this.commitActions.addLast(c);
    }

    void addUndoAction(Callback c) {
        this.undoActions.addFirst(c);
    }

    void addReleaseAction(ReleaseCallback callback) {
        this.releaseActions.add(callback);
    }

    protected int clearLogs(boolean releaseLocks) {
        this.undoActions.clear();
        this.commitActions.clear();
        if (releaseLocks) {
            return this.releaseLocks();
        }
        return 0;
    }

    private int releaseLocks() {
        int total = 0;
        int i = 0;
        while (i < this.releaseActions.size()) {
            total += this.releaseActions.get(i).release(this);
            ++i;
        }
        this.releaseActions.clear();
        i = 0;
        while (i < this.locked.size()) {
            this.locked.get(i).getOwner().set(null);
            ++total;
            ++i;
        }
        this.locked.clear();
        return total;
    }

    int performAbort() {
        Callback c;
        while ((c = this.undoActions.poll()) != null) {
            c.call();
        }
        return this.clearLogs(true);
    }

    int performCommit(boolean releaseLocks) {
        Callback c;
        while ((c = this.commitActions.poll()) != null) {
            c.call();
        }
        return this.clearLogs(releaseLocks);
    }

    Iteration recycle() {
        this.reset();
        return this;
    }

    public int getId() {
        return this.id;
    }
}

