/*
 * Decompiled with CFR 0.152.
 */
package galois.runtime;

import galois.objects.Mappable;
import galois.runtime.AbstractExecutorContext;
import galois.runtime.BarebonesExecutor;
import galois.runtime.Callback;
import galois.runtime.Executor;
import galois.runtime.Features;
import galois.runtime.ForeachContext;
import galois.runtime.Iteration;
import galois.runtime.IterationAbortException;
import galois.runtime.IterationStatistics;
import galois.runtime.MappableExecutor;
import galois.runtime.MappableType;
import galois.runtime.OrderedExecutor;
import galois.runtime.ParameterOrderedExecutor;
import galois.runtime.ParameterUnorderedExecutor;
import galois.runtime.PlaybackReplayFeature;
import galois.runtime.ReleaseCallback;
import galois.runtime.ReplayFeature;
import galois.runtime.SerialExecutor;
import galois.runtime.SerialMappableExecutor;
import galois.runtime.ThreadPool;
import galois.runtime.UnorderedExecutor;
import galois.runtime.wl.OrderableWorklist;
import galois.runtime.wl.ParameterOrderedWorklist;
import galois.runtime.wl.ParameterUnorderedWorklist;
import galois.runtime.wl.ParameterWorklist;
import galois.runtime.wl.Priority;
import galois.runtime.wl.Worklist;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.Launcher;
import util.Reflection;
import util.RuntimeStatistics;
import util.Sampler;
import util.StackSampler;
import util.Statistics;
import util.SystemProperties;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

public final class GaloisRuntime {
    private static Logger logger = Logger.getLogger("galois.runtime.GaloisRuntime");
    private static final int ITERATION_MULTIPLIER = SystemProperties.getIntProperty("iterationMultiplier", 1);
    private static GaloisRuntime instance = null;
    private boolean invalid;
    private final boolean useParameter;
    private final boolean useSerial;
    private final ReplayFeature.Type replayType;
    private final int maxThreads;
    private final int maxIterations;
    private final boolean moreStats;
    private final boolean ignoreUserFlags;
    private final ThreadSuspender threadSuspender;
    private final ArrayDeque<ExecutorFrame> stack;
    private final Executor root;
    private ExecutorFrame current;
    private static byte currentMask;

    private GaloisRuntime(int numThreads, boolean useParameter, boolean useSerial, ReplayFeature.Type replayType, boolean moreStats, boolean ignoreUserFlags) {
        this.maxIterations = ITERATION_MULTIPLIER * numThreads;
        this.maxThreads = useParameter ? 1 : numThreads;
        this.useParameter = useParameter;
        this.useSerial = useSerial;
        this.replayType = replayType;
        this.moreStats = moreStats;
        this.ignoreUserFlags = ignoreUserFlags;
        this.threadSuspender = new ThreadSuspender(this.maxThreads);
        this.stack = new ArrayDeque();
        this.root = new DummyExecutor();
        this.current = new ExecutorFrame(new ThreadPool(numThreads), this.root, 0);
        currentMask = this.current.mask;
    }

    private static void initialize(int numThreads, boolean useParameter, boolean useSerial, ReplayFeature.Type replayType, boolean moreStats, boolean ignoreUserFlags) {
        if (instance != null) {
            instance.invalidate();
        }
        instance = new GaloisRuntime(numThreads, useParameter, useSerial, replayType, moreStats, ignoreUserFlags);
    }

    public static GaloisRuntime getRuntime() {
        if (instance == null) {
            GaloisRuntime.initialize(1, false, true, ReplayFeature.Type.NO, false, false);
        }
        return instance;
    }

    public static <T> void foreach(Iterable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        GaloisRuntime.getRuntime().runBody(initial, body, priority);
    }

    public static <T> void foreach(Mappable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        GaloisRuntime.getRuntime().runBody(initial, (Lambda2Void)body, (Object)priority);
    }

    public static <T> void foreachOrdered(Iterable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        GaloisRuntime.getRuntime().runOrderedBody(initial, body, priority);
    }

    public static <T> void foreachOrdered(Mappable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        GaloisRuntime.getRuntime().runOrderedBody(initial, body, priority);
    }

    public static <T> void foreach(Mappable<T> initial, LambdaVoid<T> body) throws ExecutionException {
        GaloisRuntime.getRuntime().runBody(initial, body);
    }

    public static <T, A1> void foreach(Mappable<T> initial, Lambda2Void<T, A1> body, A1 arg1) throws ExecutionException {
        GaloisRuntime.getRuntime().runBody(initial, body, arg1);
    }

    public static <T, A1, A2> void foreach(Mappable<T> initial, Lambda3Void<T, A1, A2> body, A1 arg1, A2 arg2) throws ExecutionException {
        GaloisRuntime.getRuntime().runBody(initial, body, arg1, arg2);
    }

    private void invalidate() {
        assert (this.stack.isEmpty());
        this.current.pool.shutdown();
        this.invalid = true;
    }

    private void checkValidity() {
        assert (!this.invalid);
    }

    public void onCommit(Iteration it, Callback action) {
        this.checkValidity();
        this.current.executor.onCommit(it, action);
    }

    public void onUndo(Iteration it, Callback action) {
        this.checkValidity();
        this.current.executor.onUndo(it, action);
    }

    public void onRelease(Iteration it, ReleaseCallback action) {
        this.checkValidity();
        this.current.executor.onRelease(it, action);
    }

    public static boolean needMethodFlag(byte flags, byte option) {
        return (flags & currentMask & option) != 0;
    }

    <T> void callAll(List<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        this.checkValidity();
        this.current.pool.callAll(callables);
    }

    public int getMaxThreads() {
        this.checkValidity();
        return this.maxThreads;
    }

    public int getMaxIterations() {
        this.checkValidity();
        return this.maxIterations;
    }

    public void raiseConflict(Iteration it, Iteration conflicter) {
        this.checkValidity();
        this.current.executor.arbitrate(it, conflicter);
    }

    private void push(ExecutorFrame frame) {
        this.stack.push(this.current);
        this.current = frame;
        currentMask = this.current.mask;
    }

    private void pop() {
        this.current = this.stack.pop();
        currentMask = this.current.mask;
    }

    void replaceWithRootContextAndCall(final Callback callback) throws ExecutionException {
        ExecutorFrame oldFrame = this.current;
        this.pop();
        try {
            this.pushContextAndCall(this.root, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    callback.call();
                    return null;
                }
            });
        }
        finally {
            this.push(oldFrame);
        }
    }

    private IterationStatistics __stackSamplerRecordMe(Callable<IterationStatistics> callback) throws Exception {
        return callback.call();
    }

    private IterationStatistics pushContextAndCall(Executor executor, Callable<IterationStatistics> callback) throws ExecutionException {
        boolean isSerial;
        boolean suspended = false;
        if (!this.current.executor.isSerial()) {
            try {
                if (this.current.executor instanceof MappableExecutor) {
                    throw new Error("Not yet supported");
                }
                this.threadSuspender.suspend(this.current.executor);
                suspended = true;
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e);
            }
        }
        byte mask = (isSerial = executor.isSerial()) ? (byte)0 : -1;
        ThreadPool pool = suspended ? new ThreadPool(this.maxThreads) : this.current.pool;
        this.push(new ExecutorFrame(pool, executor, mask));
        try {
            if (isSerial) {
                IterationStatistics iterationStatistics = this.__stackSamplerRecordMe(callback);
                return iterationStatistics;
            }
            IterationStatistics iterationStatistics = callback.call();
            return iterationStatistics;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        finally {
            if (pool != null && suspended) {
                pool.shutdown();
            }
            this.pop();
        }
    }

    private <T> void initializeWorklist(final Worklist<T> wl, Iterable<T> initial, Mappable<T> mappable) throws ExecutionException {
        final SimpleContext ctx = new SimpleContext(this.maxThreads);
        if (initial != null) {
            for (T item : initial) {
                wl.addInitial(item, ctx);
            }
        } else {
            mappable.map(new LambdaVoid<T>(){

                @Override
                public void call(T item) {
                    wl.addInitial(item, ctx);
                }
            });
        }
        wl.finishAddInitial();
    }

    private <T, S> void initializeWorklist(final ParameterWorklist<T, S> wl, Iterable<T> initial, Mappable<T> mappable) throws ExecutionException {
        if (initial != null) {
            for (T item : initial) {
                wl.add(item);
            }
        } else {
            mappable.map(new LambdaVoid<T>(){

                @Override
                public void call(T item) {
                    wl.add(item);
                }
            });
        }
    }

    private <T> void runBody(Mappable<T> mappable, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        this.checkValidity();
        this.runBody(null, mappable, body, ExecutorType.UNORDERED, priority);
    }

    private <T> void runBody(Iterable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        this.checkValidity();
        this.runBody(initial, null, body, ExecutorType.UNORDERED, priority);
    }

    private <T> void runOrderedBody(Mappable<T> mappable, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        this.checkValidity();
        this.runBody(null, mappable, body, ExecutorType.ORDERED, priority);
    }

    private <T> void runOrderedBody(Iterable<T> initial, Lambda2Void<T, ForeachContext<T>> body, Priority.Rule priority) throws ExecutionException {
        this.checkValidity();
        this.runBody(initial, null, body, ExecutorType.ORDERED, priority);
    }

    private <T> void runBody(Iterable<T> initial, Mappable<T> mappable, final Lambda2Void<T, ForeachContext<T>> body, ExecutorType type, Priority.Rule priority) throws ExecutionException {
        IterationStatistics stats = null;
        if (this.replayType == ReplayFeature.Type.PLAYBACK) {
            final Worklist wl = Priority.makeSerial(priority);
            final PlaybackReplayFeature feature = (PlaybackReplayFeature)Features.getReplayFeature();
            this.initializeWorklist(wl, initial, mappable);
            stats = this.pushContextAndCall(feature, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return feature.call(body, wl);
                }
            });
        } else if (this.useSerial) {
            final Worklist wl = Priority.makeSerial(priority);
            final SerialExecutor ex = new SerialExecutor();
            this.initializeWorklist(wl, initial, mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, wl);
                }
            });
        } else if (this.useParameter) {
            if (type == ExecutorType.ORDERED) {
                ParameterOrderedWorklist wl = Priority.makeParameterOrdered(priority);
                final ParameterOrderedExecutor ex = new ParameterOrderedExecutor(wl);
                this.initializeWorklist(wl, initial, mappable);
                stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                    @Override
                    public IterationStatistics call() throws Exception {
                        return ex.call(body);
                    }
                });
            } else {
                assert (type == ExecutorType.BAREBONES || type == ExecutorType.UNORDERED);
                ParameterUnorderedWorklist wl = Priority.makeParameterUnordered();
                final ParameterUnorderedExecutor ex = new ParameterUnorderedExecutor(wl);
                this.initializeWorklist(wl, initial, mappable);
                stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                    @Override
                    public IterationStatistics call() throws Exception {
                        return ex.call(body);
                    }
                });
            }
        } else if (type == ExecutorType.ORDERED) {
            final OrderableWorklist wl = Priority.makeOrdered(priority);
            final OrderedExecutor ex = new OrderedExecutor(wl);
            this.initializeWorklist(wl, initial, mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, wl);
                }
            });
        } else if (type == ExecutorType.BAREBONES) {
            final Worklist wl = Priority.makeUnordered(priority);
            final BarebonesExecutor ex = new BarebonesExecutor();
            this.initializeWorklist(wl, initial, mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, wl);
                }
            });
        } else {
            assert (type == ExecutorType.UNORDERED);
            final Worklist wl = Priority.makeUnordered(priority);
            final UnorderedExecutor ex = new UnorderedExecutor();
            this.initializeWorklist(wl, initial, mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, wl);
                }
            });
        }
        if (stats == null) {
            throw new Error("unknown executor");
        }
        Launcher.getLauncher().addStats(stats);
        Features.getReplayFeature().onFinish();
    }

    private <T> void runBody(final Mappable<T> mappable, final Object body, final MappableType type, final Object ... args) throws ExecutionException {
        IterationStatistics stats = null;
        if (this.replayType == ReplayFeature.Type.PLAYBACK) {
            final PlaybackReplayFeature feature = (PlaybackReplayFeature)Features.getReplayFeature();
            stats = this.pushContextAndCall(feature, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return feature.call(mappable, body, type, args);
                }
            });
        } else if (this.useSerial) {
            final SerialMappableExecutor<T> ex = new SerialMappableExecutor<T>(mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, type, args);
                }
            });
        } else if (this.useParameter) {
            ParameterUnorderedWorklist wl = Priority.makeParameterUnordered();
            final ParameterUnorderedExecutor ex = new ParameterUnorderedExecutor(wl);
            this.initializeWorklist(wl, null, mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, type, args);
                }
            });
        } else {
            final MappableExecutor<T> ex = new MappableExecutor<T>(mappable);
            stats = this.pushContextAndCall(ex, new Callable<IterationStatistics>(){

                @Override
                public IterationStatistics call() throws Exception {
                    return ex.call(body, type, args);
                }
            });
        }
        if (stats == null) {
            throw new Error("unknown executor");
        }
        Launcher.getLauncher().addStats(stats);
        Features.getReplayFeature().onFinish();
    }

    private <T> void runBody(Mappable<T> mappable, LambdaVoid<T> body) throws ExecutionException {
        this.checkValidity();
        this.runBody(mappable, body, MappableType.TYPE_0, new Object[0]);
    }

    private <T, A1> void runBody(Mappable<T> mappable, Lambda2Void<T, A1> body, A1 arg1) throws ExecutionException {
        this.checkValidity();
        this.runBody(mappable, body, MappableType.TYPE_1, arg1);
    }

    private <T, A1, A2> void runBody(Mappable<T> mappable, Lambda3Void<T, A1, A2> body, A1 arg1, A2 arg2) throws ExecutionException {
        this.checkValidity();
        this.runBody(mappable, body, MappableType.TYPE_2, arg1, arg2);
    }

    public boolean useParameter() {
        this.checkValidity();
        return this.useParameter;
    }

    public boolean useSerial() {
        this.checkValidity();
        return this.useSerial;
    }

    public boolean ignoreUserFlags() {
        this.checkValidity();
        return this.ignoreUserFlags;
    }

    public boolean inRoot() {
        this.checkValidity();
        return this.current.executor == this.root;
    }

    public boolean moreStats() {
        this.checkValidity();
        return this.moreStats;
    }

    private static void dumpStatistics(List<Statistics> stats, PrintStream summaryOut, PrintStream fullOut) {
        if (stats.isEmpty()) {
            return;
        }
        fullOut.println("====== Individual Statistics ======");
        for (Statistics stat : stats) {
            stat.dumpFull(fullOut);
        }
        ArrayList<Statistics> merged = new ArrayList<Statistics>();
        HashMap reps = new HashMap();
        for (Statistics stat : stats) {
            Class<?> key = stat.getClass();
            Statistics rep = (Statistics)reps.get(key);
            if (rep == null) {
                reps.put(key, stat);
                merged.add(stat);
                continue;
            }
            rep.merge(stat);
        }
        summaryOut.println("==== Summary Statistics ====");
        fullOut.println("====== Merged Statistics ======");
        for (Statistics stat : merged) {
            stat.dumpSummary(summaryOut);
            stat.dumpFull(fullOut);
        }
    }

    private static void usage() {
        System.err.println("java -cp ... galois.runtime.GaloisRuntime [options] <main class> <args>*");
        System.err.println(" -r <num runs>      : number of runs to use");
        System.err.println(" -t <num threads>   : number of threads to use");
        System.err.println(" -f <property file> : property file to read arguments from");
        System.err.println(" -p                 : use ParaMeter");
        System.err.println(" -s                 : use serial data structures and executor");
        System.err.println(" -dr                : record execution for deterministic replay");
        System.err.println(" -dp                : playback execution from deterministic replay");
        System.err.println(" -g                 : enable additional statistics.");
        System.err.println("                      Currently: stack profiling, processor utilization");
        System.err.println(" --help             : print help");
    }

    public static void main(String[] args) throws Exception {
        String defaultArgs;
        String main = null;
        String[] mainArgs = new String[]{};
        boolean useParameter = false;
        boolean useSerial = false;
        boolean moreStats = false;
        boolean ignoreUserFlags = false;
        ReplayFeature.Type replayType = ReplayFeature.Type.NO;
        int samplerInterval = 0;
        int numThreads = 1;
        int numRuns = 1;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-r")) {
                numRuns = Integer.parseInt(args[++i]);
            } else if (arg.equals("-t")) {
                numThreads = Integer.parseInt(args[++i]);
            } else if (arg.equals("-p")) {
                useParameter = true;
            } else if (arg.equals("-f")) {
                Properties p = new Properties(System.getProperties());
                p.load(new FileInputStream(args[++i]));
                System.setProperties(p);
            } else if (arg.equals("--dr")) {
                replayType = ReplayFeature.Type.RECORD;
            } else if (arg.equals("-s")) {
                useSerial = true;
            } else if (arg.equals("--dp")) {
                replayType = ReplayFeature.Type.PLAYBACK;
                useSerial = true;
            } else if (arg.equals("-g")) {
                samplerInterval = 100;
                moreStats = true;
            } else if (arg.equals("-i")) {
                ignoreUserFlags = true;
            } else if (arg.equals("--help")) {
                GaloisRuntime.usage();
                System.exit(1);
            } else {
                main = arg;
                mainArgs = Arrays.asList(args).subList(i + 1, args.length).toArray(new String[args.length - i - 1]);
                break;
            }
            ++i;
        }
        if (main == null) {
            GaloisRuntime.usage();
            System.exit(1);
        }
        if (useParameter) {
            samplerInterval = 0;
            numThreads = 1;
            numRuns = 1;
        }
        if ((defaultArgs = System.getProperty("args")) != null) {
            if (mainArgs.length != 0) {
                System.err.println("'args' property and commandline args both given");
                System.exit(1);
            }
            mainArgs = defaultArgs.split("\\s+");
        }
        RuntimeStatistics stats = new RuntimeStatistics();
        Launcher launcher = Launcher.getLauncher();
        int i2 = 0;
        while (i2 < numRuns) {
            if (i2 != 0) {
                launcher.reset();
            }
            GaloisRuntime.initialize(numThreads, useParameter, useSerial, replayType, moreStats, ignoreUserFlags);
            Features.initialize(GaloisRuntime.getRuntime().getMaxIterations(), replayType);
            Sampler sampler = StackSampler.start(samplerInterval);
            launcher.startTiming();
            Reflection.invokeStaticMethod(main, "main", new Object[]{mainArgs});
            launcher.stopTiming();
            launcher.addStats(sampler.stop());
            long timeWithoutGc = launcher.elapsedTime(true);
            long timeWithGc = launcher.elapsedTime(false);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Runtime (ms): " + timeWithGc + " (without GC: " + timeWithoutGc + ")");
            }
            stats.putStats(timeWithoutGc, timeWithGc);
            ++i2;
        }
        launcher.addStats(stats);
        PrintStream out = new PrintStream("stats.txt");
        GaloisRuntime.dumpStatistics(launcher.getStatistics(), System.out, out);
        out.close();
    }

    private static class DummyExecutor
    implements Executor {
        private DummyExecutor() {
        }

        @Override
        public void arbitrate(Iteration current, Iteration conflicter) throws IterationAbortException {
        }

        @Override
        public void onCommit(Iteration it, Callback action) {
        }

        @Override
        public void onRelease(Iteration it, ReleaseCallback action) {
        }

        @Override
        public void onUndo(Iteration it, Callback action) {
        }

        @Override
        public boolean isSerial() {
            return true;
        }

        @Override
        public void suspend(Callback listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void suspendDone() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ExecutorFrame {
        final ThreadPool pool;
        final Executor executor;
        final byte mask;

        public ExecutorFrame(ThreadPool pool, Executor executor, byte mask) {
            this.pool = pool;
            this.executor = executor;
            this.mask = mask;
        }
    }

    private static enum ExecutorType {
        BAREBONES,
        UNORDERED,
        ORDERED;

    }

    private static class SimpleContext<T>
    extends AbstractExecutorContext<T> {
        private final int maxThreads;
        private final AtomicInteger current = new AtomicInteger();

        public SimpleContext(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        @Override
        public int getThreadId() {
            return this.current.getAndIncrement() % this.maxThreads;
        }

        @Override
        public int getIterationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ThreadSuspender
    implements Callback {
        private final ReentrantLock lock;
        private final Condition cond;
        private final int numThreads;
        private int numSuspended;
        private boolean once;

        public ThreadSuspender(int numThreads) {
            this.numThreads = numThreads;
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
        }

        private void abort() {
            IterationAbortException.throwException();
        }

        private void commit() {
            Iteration it = Iteration.getCurrentIteration();
            if (it != null) {
                it.performCommit(true);
            }
        }

        private void reset() {
            this.once = false;
            this.numSuspended = 0;
        }

        public void suspend(Executor executor) throws InterruptedException {
            this.lock.lock();
            try {
                if (this.once) {
                    this.abort();
                    return;
                }
                this.once = true;
                executor.suspend(this);
                while (this.numSuspended < this.numThreads - 1) {
                    this.cond.await();
                }
                executor.suspendDone();
                this.reset();
                this.commit();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void call() {
            this.lock.lock();
            try {
                ++this.numSuspended;
                if (this.numSuspended == this.numThreads - 1) {
                    this.cond.signal();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

