/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.ConcurrentGNode;
import galois.objects.graph.GNode;
import galois.objects.graph.ObjectGraph;
import galois.objects.graph.ObjectGraphLocker;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

final class VectorMorphObjectGraph<N extends GObject, E>
implements ObjectGraph<N, E> {
    private final AtomicReference<LinkedNode> head;
    private final AtomicInteger size;
    private final boolean isDirected;
    boolean modNodes;
    private int mapVersionNumber = 1;
    private static final int chunkSize = 64;

    VectorMorphObjectGraph() {
        this(true);
    }

    VectorMorphObjectGraph(boolean isDirected) {
        this.isDirected = isDirected;
        this.head = new AtomicReference();
        this.size = new AtomicInteger(0);
    }

    private EdgeGraphNode downcast(GNode n) {
        return (EdgeGraphNode)n;
    }

    @Override
    public GNode<N> createNode(N n) {
        return this.createNode(n, (byte)-1);
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        EdgeGraphNode ret = new EdgeGraphNode(this, (GObject)n, this.isDirected);
        ObjectGraphLocker.createNodeEpilog(ret, flags);
        return ret;
    }

    @Override
    public boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        ObjectGraphLocker.addNodeProlog(src, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        if (gsrc.add(this)) {
            this.size.incrementAndGet();
            this.modNodes = true;
            ObjectGraphLocker.addNodeEpilog(this, src, flags);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        if (!this.contains(src, flags)) {
            return false;
        }
        ObjectGraphLocker.removeNodeProlog(this, src, flags);
        this.modNodes = true;
        this.size.decrementAndGet();
        EdgeGraphNode gsrc = this.downcast(src);
        boolean ret = gsrc.remove(this);
        assert (ret);
        return true;
    }

    @Override
    public boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        ObjectGraphLocker.containsNodeProlog(src, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.inGraph(this);
    }

    @Override
    public int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        ObjectGraphLocker.sizeProlog(flags);
        int ret = this.size.get();
        assert (ret >= 0);
        return ret;
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException("addNeighbor not supported in EdgeGraphs. Use createEdge/addEdge instead");
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException("addNeighbor not supported in EdgeGraphs. Use createEdge/addEdge instead");
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        ObjectGraphLocker.removeNeighborProlog(src, dst, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        int index = gsrc.outNeighbors.indexOf(gdst);
        if (index < 0) {
            return false;
        }
        Object data = gsrc.outData.get(index);
        gsrc.removeNeighborRetEdgeData(gdst, true);
        gdst.removeNeighbor(gsrc, false);
        ObjectGraphLocker.removeNeighborEpilog(this, src, dst, data, flags);
        return true;
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        ObjectGraphLocker.hasNeighborProlog(src, dst, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        boolean ret = gsrc.outNeighbors.contains(gdst);
        assert (ret == gdst.inNeighbors.contains(gsrc));
        return ret;
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> lambda) {
        this.mapInNeighbors(src, lambda, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> lambda, byte flags) {
        ObjectGraphLocker.mapInNeighborsProlog(this, src, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        boolean prevModInNeighbors = gsrc.isModInNeighbors();
        gsrc.setModInNeighors(false);
        ArrayList neighbors = gsrc.inNeighbors;
        int size = neighbors.size();
        int i = 0;
        while (i < size) {
            this.checkForConcurrentModifications(gsrc.isModInNeighbors());
            EdgeGraphNode neighbor = (EdgeGraphNode)neighbors.get(i);
            lambda.call(neighbor);
            ++i;
        }
        this.checkForConcurrentModifications(gsrc.isModInNeighbors());
        gsrc.setModInNeighors(prevModInNeighbors);
    }

    @Override
    public int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        ObjectGraphLocker.inNeighborsSizeProlog(this, src, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.inNeighbors.size();
    }

    @Override
    public int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        ObjectGraphLocker.outNeighborsSizeProlog(src, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.outNeighbors.size();
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data) {
        return this.addEdge(src, dst, data, (byte)-1);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data, byte flags) {
        ObjectGraphLocker.addEdgeProlog(src, dst, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        if (gsrc.addNeighbor(gdst, data, true)) {
            gdst.addNeighbor(gsrc, data, false);
            ObjectGraphLocker.addEdgeEpilog(this, src, dst, flags);
            return true;
        }
        return false;
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst) {
        return this.getEdgeData(src, dst, (byte)-1);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte flags) {
        return this.getEdgeData(src, dst, flags, flags);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte edgeFlags, byte dataFlags) {
        ObjectGraphLocker.getEdgeDataProlog(src, dst, edgeFlags);
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        int index = gsrc.outNeighbors.indexOf(gdst);
        if (index >= 0) {
            Object ret = gsrc.outData.get(index);
            ObjectGraphLocker.getEdgeDataEpilog(ret, dataFlags);
            return ret;
        }
        return null;
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E d) {
        return this.setEdgeData(src, dst, d, (byte)-1);
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E data, byte flags) {
        ObjectGraphLocker.setEdgeDataProlog(src, dst, flags);
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        int index = gsrc.outNeighbors.indexOf(gdst);
        if (index < 0) {
            return null;
        }
        Object oldData = gsrc.outData.get(index);
        if (oldData != data) {
            gsrc.outData.set(index, data);
            if (gsrc != gdst || this.isDirected) {
                index = gdst.inNeighbors.indexOf(gsrc);
                assert (oldData == gdst.inData.get(index));
                gdst.inData.set(index, data);
            }
            ObjectGraphLocker.setEdgeDataEpilog(this, src, dst, oldData, flags);
        }
        return oldData;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    private boolean tryMark(EdgeGraphNode curr) {
        int old = curr.iterateVersion.get();
        if (old == this.mapVersionNumber) {
            return false;
        }
        return curr.iterateVersion.compareAndSet(old, this.mapVersionNumber);
    }

    private EdgeGraphNode scanForNode(LinkedNode start) {
        while (start != null) {
            if (start.isDummy()) {
                start = start.getNext();
                continue;
            }
            return (EdgeGraphNode)start;
        }
        return null;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        EdgeGraphNode lastSuccess = null;
        EdgeGraphNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                EdgeGraphNode next = (EdgeGraphNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        EdgeGraphNode lastSuccess = null;
        EdgeGraphNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                EdgeGraphNode next = (EdgeGraphNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur, arg1);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        EdgeGraphNode lastSuccess = null;
        EdgeGraphNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                EdgeGraphNode next = (EdgeGraphNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur, arg1, arg2);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        ObjectGraphLocker.mapProlog(flags);
        boolean prevModNodes = this.modNodes;
        this.modNodes = false;
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                this.checkForConcurrentModifications(this.modNodes);
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.isIn());
                body.call(gsrc);
            }
            curr = curr.getNext();
        }
        this.checkForConcurrentModifications(this.modNodes);
        this.modNodes = prevModNodes;
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        ObjectGraphLocker.mapProlog(flags);
        boolean prevModNodes = this.modNodes;
        this.modNodes = false;
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                this.checkForConcurrentModifications(this.modNodes);
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.isIn());
                body.call(gsrc, arg1);
            }
            curr = curr.getNext();
        }
        this.checkForConcurrentModifications(this.modNodes);
        this.modNodes = prevModNodes;
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        ObjectGraphLocker.mapProlog(flags);
        boolean prevModNodes = this.modNodes;
        this.modNodes = false;
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                this.checkForConcurrentModifications(this.modNodes);
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.isIn());
                body.call(gsrc, arg1, arg2);
            }
            curr = curr.getNext();
        }
        this.checkForConcurrentModifications(this.modNodes);
        this.modNodes = prevModNodes;
    }

    @Override
    public void mapInternalDone() {
        if (++this.mapVersionNumber == 0) {
            this.mapVersionNumber = 1;
        }
    }

    private void checkForConcurrentModifications(boolean modified) {
        if (modified) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void access(byte flags) {
    }

    private static class DummyLinkedNode
    implements LinkedNode {
        private LinkedNode next;

        private DummyLinkedNode() {
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }

    private final class EdgeGraphNode
    extends ConcurrentGNode<N>
    implements LinkedNode {
        private final AtomicStampedReference<EdgeGraphNode> iterateNext = new AtomicStampedReference<Object>(null, 0);
        private final AtomicInteger iterateVersion = new AtomicInteger();
        private final ArrayList<EdgeGraphNode> inNeighbors;
        private final ArrayList<E> inData;
        private final ArrayList<EdgeGraphNode> outNeighbors = new ArrayList(8);
        private final ArrayList<E> outData = new ArrayList(8);
        protected N data;
        private LinkedNode dummy;
        private LinkedNode next;
        private static final int NUM_NEIGHBORS = 8;
        private byte flags;
        private static final byte IN_MASK = 1;
        private static final byte MOD_IN = 2;
        private static final byte MOD_OUT = 4;
        final /* synthetic */ VectorMorphObjectGraph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private EdgeGraphNode(N d, boolean isDirected) {
            this.this$0 = (VectorMorphObjectGraph)n;
            if (isDirected) {
                this.inNeighbors = new ArrayList(8);
                this.inData = new ArrayList(8);
            } else {
                this.inNeighbors = this.outNeighbors;
                this.inData = this.outData;
            }
            this.data = d;
        }

        private boolean inGraph(VectorMorphObjectGraph<N, E> g) {
            return this.this$0 == g && this.isIn();
        }

        private boolean add(VectorMorphObjectGraph<N, E> g) {
            if (this.this$0 != g) {
                throw new UnsupportedOperationException("cannot add nodes created by a different graph");
            }
            if (!this.isIn()) {
                LinkedNode currHead;
                this.setIn(true);
                this.dummy = new DummyLinkedNode();
                this.dummy.setNext(this);
                do {
                    this.next = currHead = (LinkedNode)this.this$0.head.get();
                } while (!this.this$0.head.compareAndSet(currHead, this.dummy));
                return true;
            }
            return false;
        }

        private boolean addNeighbor(EdgeGraphNode node, E data, boolean fromOutNeighbors) {
            ArrayList<EdgeGraphNode> neighbors;
            ArrayList<EdgeGraphNode> arrayList = neighbors = fromOutNeighbors ? this.outNeighbors : this.inNeighbors;
            if (!neighbors.contains(node)) {
                neighbors.add(node);
                ArrayList neighborsData = fromOutNeighbors ? this.outData : this.inData;
                neighborsData.add(data);
                if (fromOutNeighbors) {
                    this.setModOutNeighors(true);
                } else {
                    this.setModInNeighors(true);
                }
                return true;
            }
            return false;
        }

        private boolean remove(VectorMorphObjectGraph<N, E> g) {
            if (!this.inGraph(g)) {
                return false;
            }
            this.setIn(false);
            this.dummy.setNext(this.next);
            this.iterateNext.set(null, 0);
            this.iterateVersion.set(0);
            int outNeighborsSize = this.outNeighbors.size();
            int i = 0;
            while (i < outNeighborsSize) {
                EdgeGraphNode gdst = this.outNeighbors.get(i);
                if (this != gdst || this.this$0.isDirected) {
                    gdst.removeNeighbor(this, false);
                }
                ++i;
            }
            if (this.this$0.isDirected) {
                int inNeighborsSize = this.inNeighbors.size();
                int i2 = 0;
                while (i2 < inNeighborsSize) {
                    EdgeGraphNode gsrc = this.inNeighbors.get(i2);
                    gsrc.removeNeighbor(this, true);
                    ++i2;
                }
                if (inNeighborsSize > 0) {
                    this.setModInNeighors(true);
                }
                this.inNeighbors.clear();
                this.inData.clear();
            }
            if (outNeighborsSize > 0) {
                this.setModOutNeighors(true);
            }
            this.outNeighbors.clear();
            this.outData.clear();
            return true;
        }

        private boolean removeNeighbor(EdgeGraphNode node, boolean fromOutNeighbors) {
            ArrayList<EdgeGraphNode> neighbors = fromOutNeighbors ? this.outNeighbors : this.inNeighbors;
            int index = neighbors.indexOf(node);
            if (index < 0) {
                return false;
            }
            this.removeAndGetEdgeData(neighbors, index, fromOutNeighbors);
            return true;
        }

        private E removeNeighborRetEdgeData(EdgeGraphNode node, boolean fromOutNeighbors) {
            ArrayList<EdgeGraphNode> neighbors;
            ArrayList<EdgeGraphNode> arrayList = neighbors = fromOutNeighbors ? this.outNeighbors : this.inNeighbors;
            assert (neighbors.contains(node));
            int index = neighbors.indexOf(node);
            return this.removeAndGetEdgeData(neighbors, index, fromOutNeighbors);
        }

        private E removeAndGetEdgeData(ArrayList<EdgeGraphNode> neighbors, int index, boolean fromOutNeighbors) {
            if (fromOutNeighbors) {
                this.setModOutNeighors(true);
            } else {
                this.setModInNeighors(true);
            }
            ArrayList data = fromOutNeighbors ? this.outData : this.inData;
            int indexLast = neighbors.size() - 1;
            if (index < indexLast) {
                neighbors.set(index, neighbors.remove(indexLast));
                Object ret = data.remove(indexLast);
                data.set(index, ret);
                return ret;
            }
            assert (index == indexLast);
            neighbors.remove(indexLast);
            return data.remove(indexLast);
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            ObjectGraphLocker.getNodeDataProlog(this, nodeFlags);
            Object ret = this.data;
            ObjectGraphLocker.getNodeDataEpilog(ret, dataFlags);
            return ret;
        }

        @Override
        public N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            ObjectGraphLocker.setNodeDataProlog(this, flags);
            Object oldData = this.data;
            if (oldData != data) {
                this.data = data;
                ObjectGraphLocker.setNodeDataEpilog(this, oldData, flags);
            }
            return oldData;
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                if (this.this$0.tryMark(node)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(node);
                            ctx.commit(node);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                if (this.this$0.tryMark(node)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(node, arg1);
                            ctx.commit(node);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                if (this.this$0.tryMark(node)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(node, arg1, arg2);
                            ctx.commit(node);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        @Override
        public void mapInternalDone() {
            VectorMorphObjectGraph vectorMorphObjectGraph = this.this$0;
            int n = vectorMorphObjectGraph.mapVersionNumber + 1;
            vectorMorphObjectGraph.mapVersionNumber = n;
            if (n == 0) {
                this.this$0.mapVersionNumber = 1;
            }
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            ObjectGraphLocker.mapOutNeighborsProlog(this, flags);
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                body.call(node);
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            ObjectGraphLocker.mapOutNeighborsProlog(this, flags);
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                body.call(node, arg1);
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            ObjectGraphLocker.mapOutNeighborsProlog(this, flags);
            boolean prevModOutNeighbors = this.isModOutNeighbors();
            this.setModOutNeighors(false);
            int size = this.outNeighbors.size();
            int i = 0;
            while (i < size) {
                this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
                EdgeGraphNode node = this.outNeighbors.get(i);
                body.call(node, arg1, arg2);
                ++i;
            }
            this.this$0.checkForConcurrentModifications(this.isModOutNeighbors());
            this.setModOutNeighors(prevModOutNeighbors);
        }

        private boolean isIn() {
            return (this.flags & 1) != 0;
        }

        private void setIn(boolean value) {
            this.flags = value ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
        }

        private boolean isModInNeighbors() {
            return (this.flags & 2) != 0;
        }

        private void setModInNeighors(boolean value) {
            this.flags = value ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        }

        private boolean isModOutNeighbors() {
            return (this.flags & 4) != 0;
        }

        private void setModOutNeighors(boolean value) {
            this.flags = value ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
        }
    }

    private static interface LinkedNode {
        public void setNext(LinkedNode var1);

        public LinkedNode getNext();

        public boolean isDummy();
    }
}

