/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.GNode;
import galois.objects.graph.ObjectGraph;
import galois.objects.graph.SerialGNode;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import java.util.HashMap;
import java.util.Map;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

final class SerialHashMorphObjectGraph<N extends GObject, E>
implements ObjectGraph<N, E> {
    private LinkedNode head;
    private int size;
    protected final boolean isDirected;
    private static final int chunkSize = 64;

    SerialHashMorphObjectGraph() {
        this(true);
    }

    SerialHashMorphObjectGraph(boolean isDirected) {
        this.isDirected = isDirected;
        this.size = 0;
    }

    private EdgeGraphNode downcast(GNode n) {
        return (EdgeGraphNode)n;
    }

    @Override
    public GNode<N> createNode(N n) {
        return this.createNode(n, (byte)-1);
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        EdgeGraphNode ret = new EdgeGraphNode(this, (GObject)n, this.isDirected);
        return ret;
    }

    @Override
    public boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        if (gsrc.add(this)) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        if (!this.contains(src, flags)) {
            return false;
        }
        --this.size;
        EdgeGraphNode gsrc = this.downcast(src);
        for (EdgeGraphNode gdst : gsrc.outEdges.keySet()) {
            assert (gdst.inEdges.containsKey(gsrc));
            if (gdst == gsrc && !this.isDirected) continue;
            gdst.inEdges.remove(gsrc);
        }
        if (this.isDirected) {
            for (EdgeGraphNode s : gsrc.inEdges.keySet()) {
                assert (s.outEdges.containsKey(gsrc));
                s.outEdges.remove(gsrc);
            }
            gsrc.outEdges.clear();
        }
        gsrc.inEdges.clear();
        boolean ret = gsrc.remove(this);
        assert (ret);
        return true;
    }

    @Override
    public boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.inGraph(this);
    }

    @Override
    public int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        int ret = this.size;
        assert (ret >= 0);
        return ret;
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException("addNeighbor not supported in EdgeGraphs. Use createEdge/addEdge instead");
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException("addNeighbor not supported in EdgeGraphs. Use createEdge/addEdge instead");
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        boolean ret = gsrc.outEdges.containsKey(gdst);
        if (ret) {
            Object edgeData = gsrc.outEdges.remove(gdst);
            Object sameEdgeData = gdst.inEdges.remove(gsrc);
            assert (edgeData == sameEdgeData || gsrc == gdst && !this.isDirected);
            assert (this.isDirected || gsrc.outEdges.size() == gsrc.inEdges.size());
        }
        return ret;
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        boolean ret = gsrc.outEdges.containsKey(gdst);
        assert (ret == gdst.inEdges.containsKey(gsrc));
        return ret;
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> lambda) {
        this.mapInNeighbors(src, lambda, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> lambda, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        for (EdgeGraphNode node : gsrc.inEdges.keySet()) {
            lambda.call(node);
        }
    }

    @Override
    public int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.inEdges.size();
    }

    @Override
    public int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        return gsrc.outEdges.size();
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data) {
        return this.addEdge(src, dst, data, (byte)-1);
    }

    @Override
    public boolean addEdge(GNode<N> src, GNode<N> dst, E data, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        boolean ret = gsrc.outEdges.containsKey(gdst);
        if (!ret) {
            E oldData = gsrc.outEdges.put(gdst, data);
            E sameOldData = gdst.inEdges.put(gsrc, data);
            assert (sameOldData == oldData || !this.isDirected && gsrc == gdst) : String.format("%s %s %s %s %s %s", sameOldData, oldData, this.isDirected, gsrc, gdst.getRid(), gsrc.getRid());
            assert (this.isDirected || gsrc.outEdges.size() == gsrc.inEdges.size());
            return true;
        }
        return false;
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst) {
        return this.getEdgeData(src, dst, (byte)-1);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte flags) {
        return this.getEdgeData(src, dst, flags, flags);
    }

    @Override
    public E getEdgeData(GNode<N> src, GNode<N> dst, byte nodeFlags, byte dataFlags) {
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        Object ret = gsrc.outEdges.get(gdst);
        return (E)ret;
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E d) {
        return this.setEdgeData(src, dst, d, (byte)-1);
    }

    @Override
    public E setEdgeData(GNode<N> src, GNode<N> dst, E data, byte flags) {
        EdgeGraphNode gsrc = this.downcast(src);
        EdgeGraphNode gdst = this.downcast(dst);
        if (!gsrc.outEdges.containsKey(gdst)) {
            return null;
        }
        E oldData = gsrc.outEdges.put(gdst, data);
        if (oldData != data && (gsrc != gdst || this.isDirected)) {
            E otherOldData = gdst.inEdges.put(gsrc, data);
            assert (oldData == otherOldData);
        }
        return oldData;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    private EdgeGraphNode scanForNode(LinkedNode start) {
        while (start != null) {
            if (start.isDummy()) {
                start = start.getNext();
                continue;
            }
            return (EdgeGraphNode)start;
        }
        return null;
    }

    private boolean tryMark(EdgeGraphNode n) {
        return true;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        EdgeGraphNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        EdgeGraphNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur, arg1);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        EdgeGraphNode begin = this.scanForNode(this.head);
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
            }
            EdgeGraphNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(cur, arg1, arg2);
                            ctx.commit(cur);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.in);
                body.call(gsrc);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        LinkedNode curr = this.head;
        while (curr != null) {
            if (!curr.isDummy()) {
                EdgeGraphNode gsrc = (EdgeGraphNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1, arg2);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public void mapInternalDone() {
    }

    @Override
    public void access(byte flags) {
    }

    private static class DummyLinkedNode
    implements LinkedNode {
        private LinkedNode next;

        private DummyLinkedNode() {
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }

    private final class EdgeGraphNode
    extends SerialGNode<N>
    implements LinkedNode {
        private final Map<EdgeGraphNode, E> inEdges;
        private final Map<EdgeGraphNode, E> outEdges = new HashMap(8);
        protected N data;
        private boolean in;
        private LinkedNode dummy;
        private LinkedNode next;
        private static final int NUM_NEIGHBORS = 8;
        final /* synthetic */ SerialHashMorphObjectGraph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private EdgeGraphNode(N d, boolean isDirected) {
            this.this$0 = (SerialHashMorphObjectGraph)n;
            this.inEdges = isDirected ? new HashMap(8) : this.outEdges;
            this.data = d;
        }

        private boolean inGraph(SerialHashMorphObjectGraph<N, E> g) {
            return this.this$0 == g && this.in;
        }

        private boolean add(SerialHashMorphObjectGraph<N, E> g) {
            if (this.this$0 != g) {
                throw new UnsupportedOperationException("cannot add nodes created by a different graph");
            }
            if (!this.in) {
                LinkedNode currHead;
                this.in = true;
                this.dummy = new DummyLinkedNode();
                this.dummy.setNext(this);
                this.next = currHead = this.this$0.head;
                this.this$0.head = this.dummy;
                return true;
            }
            return false;
        }

        private boolean remove(SerialHashMorphObjectGraph<N, E> g) {
            if (this.inGraph(g)) {
                this.in = false;
                this.dummy.setNext(this.next);
                return true;
            }
            return false;
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            Object ret = this.data;
            return ret;
        }

        @Override
        public N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            Object oldData = this.data;
            if (oldData != data) {
                this.data = data;
            }
            return oldData;
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            block2: for (EdgeGraphNode node : this.outEdges.keySet()) {
                if (!this.this$0.tryMark(node)) continue;
                while (true) {
                    try {
                        ctx.begin();
                        body.call(node);
                        ctx.commit(node);
                        continue block2;
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            block2: for (EdgeGraphNode node : this.outEdges.keySet()) {
                if (!this.this$0.tryMark(node)) continue;
                while (true) {
                    try {
                        ctx.begin();
                        body.call(node, arg1);
                        ctx.commit(node);
                        continue block2;
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            block2: for (EdgeGraphNode node : this.outEdges.keySet()) {
                if (!this.this$0.tryMark(node)) continue;
                while (true) {
                    try {
                        ctx.begin();
                        body.call(node, arg1, arg2);
                        ctx.commit(node);
                        continue block2;
                    }
                    catch (IterationAbortException iae) {
                        ctx.abort();
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public void mapInternalDone() {
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            for (EdgeGraphNode node : this.outEdges.keySet()) {
                body.call(node);
            }
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            for (EdgeGraphNode node : this.outEdges.keySet()) {
                body.call(node, arg1);
            }
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            for (EdgeGraphNode node : this.outEdges.keySet()) {
                body.call(node, arg1, arg2);
            }
        }
    }

    private static interface LinkedNode {
        public void setNext(LinkedNode var1);

        public LinkedNode getNext();

        public boolean isDummy();
    }
}

