/*
 * Decompiled with CFR 0.152.
 */
package galois.objects.graph;

import galois.objects.GObject;
import galois.objects.graph.ConcurrentGNode;
import galois.objects.graph.GNode;
import galois.objects.graph.IndexedGraph;
import galois.objects.graph.IndexedGraphToAllIndexedGraphAdapter;
import galois.objects.graph.IndexedTreeLocker;
import galois.objects.graph.ObjectGraphLocker;
import galois.objects.graph.SerialArrayIndexedTree;
import galois.runtime.GaloisRuntime;
import galois.runtime.IterationAbortException;
import galois.runtime.MapInternalContext;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicStampedReference;
import util.fn.Lambda2Void;
import util.fn.Lambda3Void;
import util.fn.LambdaVoid;

public final class ArrayIndexedTree<N extends GObject>
implements IndexedGraph<N> {
    private final int maxNeighbors;
    private final AtomicReference<LinkedNode> head;
    private final AtomicInteger size;
    private int mapVersionNumber = 1;
    private static final int chunkSize = 64;

    private ArrayIndexedTree(int capacity) {
        assert (capacity > 0);
        this.maxNeighbors = capacity;
        this.head = new AtomicReference();
        this.size = new AtomicInteger(0);
    }

    @Override
    public final GNode<N> createNode(N n) {
        return this.createNode(n, (byte)-1);
    }

    @Override
    public GNode<N> createNode(N n, byte flags) {
        IndexedTreeNode ret = new IndexedTreeNode(this, n);
        ObjectGraphLocker.createNodeEpilog(ret, flags);
        return ret;
    }

    @Override
    public final boolean add(GNode<N> src) {
        return this.add(src, (byte)-1);
    }

    @Override
    public boolean add(GNode<N> src, byte flags) {
        IndexedTreeLocker.addNodeProlog(src, flags);
        if (((IndexedTreeNode)src).add(this)) {
            this.size.incrementAndGet();
            IndexedTreeLocker.addNodeEpilog(this, src, flags);
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(GNode<N> src) {
        return this.remove(src, (byte)-1);
    }

    @Override
    public boolean remove(GNode<N> src, byte flags) {
        if (!this.contains(src, flags)) {
            return false;
        }
        IndexedTreeLocker.removeNodeProlog(src, flags);
        this.size.decrementAndGet();
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        int i = 0;
        while (i < this.maxNeighbors) {
            if (ignsrc.child[i] != null) {
                this.removeNeighbor(ignsrc, i, flags);
            }
            ++i;
        }
        if (ignsrc.parent != null) {
            this.removeNeighbor(ignsrc.parent, ignsrc, flags);
        }
        boolean ret = ignsrc.remove(this);
        assert (ret);
        return true;
    }

    @Override
    public final boolean contains(GNode<N> src) {
        return this.contains(src, (byte)-1);
    }

    @Override
    public boolean contains(GNode<N> src, byte flags) {
        IndexedTreeLocker.containsNodeProlog(src, flags);
        return ((IndexedTreeNode)src).inGraph(this);
    }

    @Override
    public final int size() {
        return this.size((byte)-1);
    }

    @Override
    public int size(byte flags) {
        IndexedTreeLocker.sizeProlog(flags);
        int ret = this.size.get();
        assert (ret >= 0);
        return ret;
    }

    @Override
    public final boolean addNeighbor(GNode<N> src, GNode<N> dst) {
        throw new UnsupportedOperationException("addNeighbor not supported in IndexedGraphs");
    }

    @Override
    public boolean addNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        throw new UnsupportedOperationException("addNeighbor not supported in IndexedGraphs");
    }

    @Override
    public final boolean removeNeighbor(GNode<N> src, GNode<N> dst) {
        return this.removeNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        IndexedTreeLocker.removeNeighborProlog(src, dst, flags);
        int idx = this.childIndex(src, dst);
        if (idx >= 0) {
            this.removeNeighbor(src, idx, flags);
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasNeighbor(GNode<N> src, GNode<N> dst) {
        return this.hasNeighbor(src, dst, (byte)-1);
    }

    @Override
    public boolean hasNeighbor(GNode<N> src, GNode<N> dst, byte flags) {
        IndexedTreeLocker.hasNeighborProlog(src, dst, flags);
        return this.childIndex(src, dst) >= 0;
    }

    @Override
    public final void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> body) {
        this.mapInNeighbors(src, body, (byte)-1);
    }

    @Override
    public void mapInNeighbors(GNode<N> src, LambdaVoid<GNode<N>> closure, byte flags) {
        IndexedTreeLocker.mapInNeighborsProlog(this, src, flags);
        IndexedTreeNode n = (IndexedTreeNode)src;
        if (n.parent != null) {
            closure.call(n.parent);
        }
    }

    @Override
    public final int inNeighborsSize(GNode<N> src) {
        return this.inNeighborsSize(src, (byte)-1);
    }

    @Override
    public int inNeighborsSize(GNode<N> src, byte flags) {
        IndexedTreeLocker.inNeighborsSizeProlog(this, src, flags);
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        if (ignsrc.parent != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public final int outNeighborsSize(GNode<N> src) {
        return this.outNeighborsSize(src, (byte)-1);
    }

    @Override
    public int outNeighborsSize(GNode<N> src, byte flags) {
        IndexedTreeLocker.outNeighborsSizeProlog(src, flags);
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        int cnt = 0;
        int i = 0;
        while (i < this.maxNeighbors) {
            if (ignsrc.child[i] != null) {
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public final void setNeighbor(GNode<N> src, GNode<N> dst, int idx) {
        this.setNeighbor(src, dst, idx, (byte)-1);
    }

    @Override
    public void setNeighbor(GNode<N> src, GNode<N> dst, int idx, byte flags) {
        IndexedTreeLocker.setNeighborProlog(src, dst, flags);
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        IndexedTreeNode old = ignsrc.child[idx];
        if (old != dst) {
            IndexedTreeNode igndst = (IndexedTreeNode)dst;
            if (igndst.parent != null) {
                this.removeNeighbor(igndst.parent, igndst, flags);
            }
            igndst.parent = ignsrc;
            if (old != null) {
                this.removeNeighbor(ignsrc, idx, flags);
            }
            ignsrc.child[idx] = igndst;
            IndexedTreeLocker.setNeighborEpilog(old, flags);
        }
    }

    @Override
    public final GNode<N> getNeighbor(GNode<N> node, int idx) {
        return this.getNeighbor(node, idx, (byte)-1);
    }

    @Override
    public GNode<N> getNeighbor(GNode<N> node, int idx, byte flags) {
        IndexedTreeLocker.getNeighborProlog(node, flags);
        IndexedTreeNode ignode = (IndexedTreeNode)node;
        IndexedTreeNode ret = ignode.child[idx];
        if (ret != null) {
            IndexedTreeLocker.getNeighborEpilog(ret, flags);
        }
        return ret;
    }

    @Override
    public final boolean removeNeighbor(GNode<N> node, int idx) {
        return this.removeNeighbor(node, idx, (byte)-1);
    }

    @Override
    public boolean removeNeighbor(GNode<N> src, int idx, byte flags) {
        IndexedTreeLocker.removeNeighborProlog(src, flags);
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        IndexedTreeNode child = ignsrc.child[idx];
        if (child != null) {
            ignsrc.child[idx].parent = null;
            ignsrc.child[idx] = null;
            IndexedTreeLocker.removeNeighborEpilog(this, src, child, idx, flags);
            return true;
        }
        return false;
    }

    private int childIndex(GNode<N> src, GNode<N> dst) {
        IndexedTreeNode ignsrc = (IndexedTreeNode)src;
        List<IndexedTreeNode> neighborList = Arrays.asList(ignsrc.child);
        return neighborList.indexOf(dst);
    }

    private boolean tryMark(IndexedTreeNode curr) {
        int old = curr.iterateVersion.get();
        if (old == this.mapVersionNumber) {
            return false;
        }
        return curr.iterateVersion.compareAndSet(old, this.mapVersionNumber);
    }

    private IndexedTreeNode scanForNode(LinkedNode start) {
        while (start != null) {
            if (start.isDummy()) {
                start = start.getNext();
                continue;
            }
            return (IndexedTreeNode)start;
        }
        return null;
    }

    @Override
    public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
        IndexedTreeNode lastSuccess = null;
        IndexedTreeNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                IndexedTreeNode next = (IndexedTreeNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
        IndexedTreeNode lastSuccess = null;
        IndexedTreeNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                IndexedTreeNode next = (IndexedTreeNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur, arg1);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
        IndexedTreeNode lastSuccess = null;
        IndexedTreeNode begin = this.scanForNode(this.head.get());
        int[] holder = new int[1];
        while (begin != null) {
            boolean owned = false;
            if (this.tryMark(begin)) {
                owned = true;
                if (lastSuccess != null) {
                    lastSuccess.iterateNext.set(begin, this.mapVersionNumber);
                }
                lastSuccess = begin;
            } else {
                IndexedTreeNode next = (IndexedTreeNode)begin.iterateNext.get(holder);
                if (holder[0] == this.mapVersionNumber) {
                    begin = next;
                    continue;
                }
            }
            IndexedTreeNode cur = begin;
            int i = 0;
            while (i < 64) {
                if (owned) {
                    while (true) {
                        try {
                            cur.iterateNext.set(null, 0);
                            ctx.begin();
                            body.call(cur, arg1, arg2);
                            ctx.commit(cur);
                            if (i == 0) break;
                            cur.iterateVersion.set(0);
                        }
                        catch (IterationAbortException e) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                if ((cur = this.scanForNode(cur.next)) == null) break;
                ++i;
            }
            begin = cur;
        }
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body) {
        this.map(body, (byte)-1);
    }

    @Override
    public void map(LambdaVoid<GNode<N>> body, byte flags) {
        IndexedTreeLocker.mapProlog(flags);
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
        this.map(body, arg1, (byte)-1);
    }

    @Override
    public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
        IndexedTreeLocker.mapProlog(flags);
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
        this.map(body, arg1, arg2, (byte)-1);
    }

    @Override
    public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
        IndexedTreeLocker.mapProlog(flags);
        LinkedNode curr = this.head.get();
        while (curr != null) {
            if (!curr.isDummy()) {
                IndexedTreeNode gsrc = (IndexedTreeNode)curr;
                assert (gsrc.in);
                body.call(gsrc, arg1, arg2);
            }
            curr = curr.getNext();
        }
    }

    @Override
    public void mapInternalDone() {
        if (++this.mapVersionNumber == 0) {
            this.mapVersionNumber = 1;
        }
    }

    @Override
    public void access(byte flags) {
    }

    /* synthetic */ ArrayIndexedTree(int n, ArrayIndexedTree arrayIndexedTree) {
        this(n);
    }

    public static class Builder {
        private int branchingFactor = 2;
        private boolean serial = false;

        public Builder branchingFactor(int branchingFactor) {
            this.branchingFactor = branchingFactor;
            return this;
        }

        public Builder serial(boolean serial) {
            this.serial = serial;
            return this;
        }

        public <N extends GObject> IndexedGraph<N> create() {
            IndexedGraph retval = this.serial || GaloisRuntime.getRuntime().useSerial() ? new SerialArrayIndexedTree(this.branchingFactor) : new ArrayIndexedTree(this.branchingFactor, null);
            if (GaloisRuntime.getRuntime().ignoreUserFlags()) {
                retval = new IndexedGraphToAllIndexedGraphAdapter(retval);
            }
            return retval;
        }
    }

    private static class DummyLinkedNode
    implements LinkedNode {
        private LinkedNode next;

        private DummyLinkedNode() {
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }

    protected static final class IndexedTreeNode
    extends ConcurrentGNode<N>
    implements LinkedNode {
        private final AtomicStampedReference<IndexedTreeNode> iterateNext = new AtomicStampedReference<Object>(null, 0);
        private final AtomicInteger iterateVersion = new AtomicInteger();
        protected N data;
        protected IndexedTreeNode[] child;
        protected IndexedTreeNode parent;
        private boolean in;
        private LinkedNode dummy;
        private LinkedNode next;
        final /* synthetic */ ArrayIndexedTree this$0;

        public IndexedTreeNode(N nodedata) {
            this.this$0 = var1_1;
            this.data = nodedata;
            this.child = (IndexedTreeNode[])Array.newInstance(this.getClass(), ((ArrayIndexedTree)var1_1).maxNeighbors);
            Arrays.fill(this.child, null);
            this.parent = null;
        }

        private boolean inGraph(ArrayIndexedTree<N> g) {
            return this.this$0 == g && this.in;
        }

        private boolean add(ArrayIndexedTree<N> g) {
            if (this.this$0 != g) {
                throw new UnsupportedOperationException("cannot add nodes created by a different graph");
            }
            if (!this.in) {
                LinkedNode currHead;
                this.in = true;
                this.dummy = new DummyLinkedNode();
                this.dummy.setNext(this);
                do {
                    this.next = currHead = (LinkedNode)this.this$0.head.get();
                } while (!this.this$0.head.compareAndSet(currHead, this.dummy));
                return true;
            }
            return false;
        }

        private boolean remove(ArrayIndexedTree<N> g) {
            if (this.inGraph(g)) {
                this.in = false;
                this.iterateNext.set(null, 0);
                this.iterateVersion.set(0);
                this.dummy.setNext(this.next);
                return true;
            }
            return false;
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @Override
        public LinkedNode getNext() {
            return this.next;
        }

        @Override
        public void setNext(LinkedNode next) {
            this.next = next;
        }

        @Override
        public final N getData() {
            return this.getData((byte)-1);
        }

        @Override
        public final N getData(byte flags) {
            return this.getData(flags, flags);
        }

        @Override
        public N getData(byte nodeFlags, byte dataFlags) {
            IndexedTreeLocker.getNodeDataProlog(this, nodeFlags);
            Object ret = this.data;
            IndexedTreeLocker.getNodeDataEpilog(ret, dataFlags);
            return ret;
        }

        @Override
        public final N setData(N data) {
            return this.setData((N)data, (byte)-1);
        }

        @Override
        public N setData(N data, byte flags) {
            IndexedTreeLocker.setNodeDataProlog(this, flags);
            Object oldData = this.data;
            this.data = data;
            IndexedTreeLocker.setNodeDataEpilog(this, oldData, flags);
            return oldData;
        }

        @Override
        public void mapInternal(LambdaVoid<GNode<N>> body, MapInternalContext ctx) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.this$0.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public <A1> void mapInternal(Lambda2Void<GNode<N>, A1> body, MapInternalContext ctx, A1 arg1) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.this$0.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c, arg1);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public <A1, A2> void mapInternal(Lambda3Void<GNode<N>, A1, A2> body, MapInternalContext ctx, A1 arg1, A2 arg2) {
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null && this.this$0.tryMark(c)) {
                    while (true) {
                        try {
                            ctx.begin();
                            body.call(c, arg1, arg2);
                            ctx.commit(c);
                        }
                        catch (IterationAbortException iae) {
                            ctx.abort();
                            continue;
                        }
                        break;
                    }
                }
                ++i;
            }
        }

        @Override
        public final void map(LambdaVoid<GNode<N>> body) {
            this.map(body, (byte)-1);
        }

        @Override
        public void map(LambdaVoid<GNode<N>> body, byte flags) {
            IndexedTreeLocker.mapOutNeighborsProlog(this, flags);
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c);
                }
                ++i;
            }
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1) {
            this.map(body, arg1, (byte)-1);
        }

        @Override
        public <A1> void map(Lambda2Void<GNode<N>, A1> body, A1 arg1, byte flags) {
            IndexedTreeLocker.mapOutNeighborsProlog(this, flags);
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c, arg1);
                }
                ++i;
            }
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2) {
            this.map(body, arg1, arg2, (byte)-1);
        }

        @Override
        public <A1, A2> void map(Lambda3Void<GNode<N>, A1, A2> body, A1 arg1, A2 arg2, byte flags) {
            IndexedTreeLocker.mapOutNeighborsProlog(this, flags);
            int i = 0;
            while (i < this.this$0.maxNeighbors) {
                IndexedTreeNode c = this.child[i];
                if (c != null) {
                    body.call(c, arg1, arg2);
                }
                ++i;
            }
        }

        @Override
        public void mapInternalDone() {
            ArrayIndexedTree arrayIndexedTree = this.this$0;
            int n = arrayIndexedTree.mapVersionNumber + 1;
            arrayIndexedTree.mapVersionNumber = n;
            if (n == 0) {
                this.this$0.mapVersionNumber = 1;
            }
        }
    }

    private static interface LinkedNode {
        public void setNext(LinkedNode var1);

        public LinkedNode getNext();

        public boolean isDummy();
    }
}

