/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.GMap;
import galois.objects.GObject;
import galois.objects.Lockable;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GMapBuilder<K extends Lockable, V extends GObject> {
    public GMap<K, V> create() {
        if (GaloisRuntime.getRuntime().useSerial()) {
            return new SerialGMap();
        }
        return new ConcurrentGMap();
    }

    private static class ConcurrentGMap<K extends Lockable, V extends GObject>
    implements GMap<K, V> {
        private Map<K, V> map = new ConcurrentHashMap();

        @Override
        public final int size() {
            return this.size((byte)-1);
        }

        @Override
        public int size(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.isEmpty((byte)-1);
        }

        @Override
        public boolean isEmpty(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return this.map.isEmpty();
        }

        @Override
        public final boolean containsKey(Object arg0) {
            return this.containsKey(arg0, (byte)-1);
        }

        @Override
        public boolean containsKey(Object arg0, byte flags) {
            Iteration.acquire((Lockable)arg0, flags);
            return this.map.containsKey(arg0);
        }

        @Override
        public final boolean containsValue(Object arg0) {
            return this.containsValue(arg0, (byte)-1);
        }

        @Override
        public boolean containsValue(Object arg0, byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return this.map.containsValue(arg0);
        }

        @Override
        public final V get(Object arg0) {
            return this.get(arg0, (byte)-1);
        }

        @Override
        public V get(Object arg0, byte flags) {
            return this.get(arg0, flags, flags);
        }

        @Override
        public V get(Object arg0, byte keyFlags, byte valueFlags) {
            Iteration.acquire((Lockable)arg0, keyFlags);
            GObject retval = (GObject)this.map.get(arg0);
            if (retval != null) {
                retval.access(valueFlags);
            }
            return (V)retval;
        }

        @Override
        public final V put(K arg0, V arg1) {
            return this.put(arg0, arg1, (byte)-1);
        }

        @Override
        public V put(K arg0, V arg1, byte flags) {
            return this.put(arg0, arg1, flags, flags);
        }

        @Override
        public V put(K arg0, V arg1, byte keyFlags, byte valueFlags) {
            boolean hadEntry;
            Iteration it = Iteration.acquire(arg0, keyFlags);
            GObject retval = (GObject)this.map.put(arg0, arg1);
            boolean bl = hadEntry = retval != null;
            if (GaloisRuntime.needMethodFlag(keyFlags, (byte)2)) {
                if (it == null) {
                    it = Iteration.getCurrentIteration();
                }
                GaloisRuntime.getRuntime().onUndo(it, new Callback((Lockable)arg0, retval){
                    private final /* synthetic */ Lockable val$arg0;
                    private final /* synthetic */ GObject val$retval;
                    {
                        this.val$arg0 = lockable;
                        this.val$retval = gObject;
                    }

                    @Override
                    public void call() {
                        if (hadEntry) {
                            map.put(this.val$arg0, this.val$retval);
                        } else {
                            map.remove(this.val$arg0);
                        }
                    }
                });
            }
            if (retval != null) {
                retval.access(valueFlags);
            }
            return (V)retval;
        }

        @Override
        public final V remove(Object arg0) {
            return this.remove(arg0, (byte)-1);
        }

        @Override
        public V remove(Object arg0, byte flags) {
            return this.remove(arg0, flags, flags);
        }

        @Override
        public V remove(final Object arg0, byte keyFlags, byte valueFlags) {
            boolean hadEntry;
            Iteration it = Iteration.acquire((Lockable)arg0, keyFlags);
            final GObject retval = (GObject)this.map.remove(arg0);
            boolean bl = hadEntry = retval != null;
            if (hadEntry && GaloisRuntime.needMethodFlag(keyFlags, (byte)2)) {
                if (it == null) {
                    it = Iteration.getCurrentIteration();
                }
                GaloisRuntime.getRuntime().onUndo(it, new Callback(){

                    @Override
                    public void call() {
                        map.put((Lockable)arg0, retval);
                    }
                });
            }
            if (retval != null) {
                retval.access(valueFlags);
            }
            return (V)retval;
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> arg0) {
            this.putAll(arg0, (byte)-1);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0, byte flags) {
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                this.put((K)((Lockable)entry.getKey()), (V)((GObject)entry.getValue()));
            }
        }

        @Override
        public final void clear() {
            this.clear((byte)-1);
        }

        @Override
        public void clear(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)3)) {
                throw new Error("no globals");
            }
            this.map.clear();
        }

        @Override
        public final Set<K> keySet() {
            return this.keySet((byte)-1);
        }

        @Override
        public Set<K> keySet(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public final Collection<V> values() {
            return this.values((byte)-1);
        }

        @Override
        public Collection<V> values(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return Collections.unmodifiableCollection(this.map.values());
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet((byte)-1);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return Collections.unmodifiableSet(this.map.entrySet());
        }

        @Override
        public final boolean equals(Object arg0) {
            return this.equals((byte)-1);
        }

        @Override
        public boolean equals(Object arg0, byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return this.map.equals(arg0);
        }

        @Override
        public final int hashCode() {
            return this.hashCode((byte)-1);
        }

        @Override
        public int hashCode(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("no globals");
            }
            return this.map.hashCode();
        }
    }

    private static class SerialGMap<K extends Lockable, V extends GObject>
    implements GMap<K, V> {
        private Map<K, V> map = new HashMap();

        @Override
        public int size(byte flags) {
            return this.map.size();
        }

        @Override
        public boolean isEmpty(byte flags) {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object arg0, byte flags) {
            return this.map.containsKey(arg0);
        }

        @Override
        public boolean containsValue(Object arg0, byte flags) {
            return this.map.containsValue(arg0);
        }

        @Override
        public V get(Object arg0, byte flags) {
            return this.get(arg0, flags, flags);
        }

        @Override
        public V get(Object arg0, byte keyFlags, byte valueFlags) {
            return (V)((GObject)this.map.get(arg0));
        }

        @Override
        public V put(K arg0, V arg1, byte flags) {
            return this.put(arg0, arg1, flags, flags);
        }

        @Override
        public V put(K arg0, V arg1, byte keyFlags, byte valueFlags) {
            GObject retval = (GObject)this.map.put(arg0, arg1);
            return (V)retval;
        }

        @Override
        public V remove(Object arg0, byte flags) {
            return this.remove(arg0, flags, flags);
        }

        @Override
        public V remove(Object arg0, byte keyFlags, byte valueFlags) {
            GObject retval = (GObject)this.map.remove(arg0);
            return (V)retval;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0, byte flags) {
            this.map.putAll(arg0);
        }

        @Override
        public void clear(byte flags) {
            this.map.clear();
        }

        @Override
        public Set<K> keySet(byte flags) {
            return Collections.unmodifiableSet(this.map.keySet());
        }

        @Override
        public Collection<V> values(byte flags) {
            return Collections.unmodifiableCollection(this.map.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet(byte flags) {
            return Collections.unmodifiableSet(this.map.entrySet());
        }

        @Override
        public boolean equals(Object arg0, byte flags) {
            return this.map.equals(arg0);
        }

        @Override
        public int hashCode(byte flags) {
            return this.map.hashCode();
        }

        @Override
        public final boolean isEmpty() {
            return this.isEmpty((byte)-1);
        }

        @Override
        public final boolean containsKey(Object arg0) {
            return this.containsKey(arg0, (byte)-1);
        }

        @Override
        public final boolean containsValue(Object arg0) {
            return this.containsValue(arg0, (byte)-1);
        }

        @Override
        public final V get(Object arg0) {
            return this.get(arg0, (byte)-1);
        }

        @Override
        public final V put(K arg0, V arg1) {
            return this.put(arg0, arg1, (byte)-1);
        }

        @Override
        public final V remove(Object arg0) {
            return this.remove(arg0, (byte)-1);
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> arg0) {
            this.putAll(arg0, (byte)-1);
        }

        @Override
        public final void clear() {
            this.clear((byte)-1);
        }

        @Override
        public final Set<K> keySet() {
            return this.keySet((byte)-1);
        }

        @Override
        public final Collection<V> values() {
            return this.values((byte)-1);
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            return this.entrySet((byte)-1);
        }

        @Override
        public final boolean equals(Object arg0) {
            return this.equals((byte)-1);
        }

        @Override
        public final int hashCode() {
            return this.hashCode((byte)-1);
        }

        @Override
        public final int size() {
            return this.size((byte)-1);
        }
    }
}

