/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.Bag;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public class BagBuilder<T> {
    public Bag<T> create() {
        if (GaloisRuntime.getRuntime().useSerial()) {
            return new SerialBag();
        }
        return new ConcurrentBag();
    }

    private static class ConcurrentBag<T>
    implements Bag<T> {
        private final AtomicReference<Node<T>> head = new AtomicReference();
        private final GaloisRuntime runtime = GaloisRuntime.getRuntime();

        private ConcurrentBag() {
        }

        @Override
        public final boolean add(T o) {
            return this.add(o, (byte)-1);
        }

        @Override
        public boolean add(T o, byte flags) {
            Node<T> node;
            Node<T> cur;
            while (!this.head.compareAndSet(cur = this.head.get(), node = new Node<T>(o, cur))) {
            }
            if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
                final Node<T> n = node;
                this.runtime.onUndo(Iteration.getCurrentIteration(), new Callback(){

                    @Override
                    public void call() {
                        n.absent = true;
                    }
                });
            }
            return true;
        }

        @Override
        public final boolean addAll(Collection<? extends T> c) {
            return this.addAll(c, (byte)-1);
        }

        @Override
        public boolean addAll(Collection<? extends T> c, byte flags) {
            for (T o : c) {
                this.add(o, flags);
            }
            return true;
        }

        @Override
        public final void clear() {
            this.clear((byte)-1);
        }

        @Override
        public void clear(byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean contains(Object o) {
            return this.contains(o, (byte)-1);
        }

        @Override
        public boolean contains(Object o, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            return this.containsAll(c, (byte)-1);
        }

        @Override
        public boolean containsAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isEmpty() {
            return this.isEmpty((byte)-1);
        }

        @Override
        public boolean isEmpty(byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<T> iterator() {
            return this.iterator((byte)-1);
        }

        @Override
        public Iterator<T> iterator(byte flags) {
            if (GaloisRuntime.needMethodFlag(flags, (byte)1)) {
                throw new Error("No global actions during parallel execution");
            }
            return new Iterator<T>(){
                Node<T> cur;
                {
                    this.cur = (Node)concurrentBag.head.get();
                }

                @Override
                public boolean hasNext() {
                    while (this.cur != null) {
                        if (!this.cur.absent) {
                            return true;
                        }
                        this.cur = this.cur.next;
                    }
                    return false;
                }

                @Override
                public T next() {
                    Object retval = this.cur.obj;
                    this.cur = this.cur.next;
                    return retval;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public final boolean remove(Object o) {
            return this.remove(o, (byte)-1);
        }

        @Override
        public boolean remove(Object o, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            return this.removeAll(c, (byte)-1);
        }

        @Override
        public boolean removeAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            return this.retainAll(c, (byte)-1);
        }

        @Override
        public boolean retainAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return this.size((byte)-1);
        }

        @Override
        public int size(byte flags) {
            Iterator<T> iterator = this.iterator(flags);
            int ret = 0;
            while (iterator.hasNext()) {
                ++ret;
                iterator.next();
            }
            return ret;
        }

        @Override
        public final Object[] toArray() {
            return this.toArray((byte)-1);
        }

        @Override
        public Object[] toArray(byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final <U> U[] toArray(U[] a) {
            return this.toArray(a, (byte)-1);
        }

        @Override
        public <U> U[] toArray(U[] a, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void access(byte flags) {
        }

        private static class Node<T> {
            private boolean absent;
            private final Node<T> next;
            private final T obj;

            public Node(T obj, Node<T> next) {
                this.obj = obj;
                this.next = next;
            }
        }
    }

    private static class SerialBag<T>
    implements Bag<T> {
        private Node<T> head = null;
        int size = 0;

        @Override
        public boolean add(T o, byte flags) {
            Node<T> cur = this.head;
            this.head = new Node<T>(o, cur);
            ++this.size;
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c, byte flags) {
            for (T o : c) {
                this.add(o, flags);
            }
            return true;
        }

        @Override
        public void clear(byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty(byte flags) {
            return this.size == 0;
        }

        @Override
        public Iterator<T> iterator(byte flags) {
            return new Iterator<T>(){
                Node<T> cur;
                {
                    this.cur = serialBag.head;
                }

                @Override
                public boolean hasNext() {
                    while (this.cur != null) {
                        if (!this.cur.absent) {
                            return true;
                        }
                        this.cur = this.cur.next;
                    }
                    return false;
                }

                @Override
                public T next() {
                    Object retval = this.cur.obj;
                    this.cur = this.cur.next;
                    return retval;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object o, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size(byte flags) {
            return this.size;
        }

        @Override
        public Object[] toArray(byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <U> U[] toArray(U[] a, byte flags) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean add(T o) {
            return this.add(o, (byte)-1);
        }

        @Override
        public final boolean addAll(Collection<? extends T> c) {
            return this.addAll(c, (byte)-1);
        }

        @Override
        public final void clear() {
            this.clear((byte)-1);
        }

        @Override
        public final boolean contains(Object o) {
            return this.contains(o, (byte)-1);
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            return this.containsAll(c, (byte)-1);
        }

        @Override
        public final boolean isEmpty() {
            return this.isEmpty((byte)-1);
        }

        @Override
        public final Iterator<T> iterator() {
            return this.iterator((byte)-1);
        }

        @Override
        public final boolean remove(Object o) {
            return this.remove(o, (byte)-1);
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            return this.removeAll(c, (byte)-1);
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            return this.retainAll(c, (byte)-1);
        }

        @Override
        public final int size() {
            return this.size((byte)-1);
        }

        @Override
        public final Object[] toArray() {
            return this.toArray((byte)-1);
        }

        @Override
        public final <U> U[] toArray(U[] a) {
            return this.toArray(a, (byte)-1);
        }

        @Override
        public void access(byte flags) {
        }

        private static class Node<T> {
            private boolean absent;
            private final Node<T> next;
            private final T obj;

            public Node(T obj, Node<T> next) {
                this.obj = obj;
                this.next = next;
            }
        }
    }
}

