/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.Accumulator;
import galois.runtime.Callback;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import java.util.concurrent.atomic.AtomicInteger;

public class AccumulatorBuilder {
    public Accumulator create() {
        return this.create(0);
    }

    public Accumulator create(int value) {
        if (GaloisRuntime.getRuntime().useSerial()) {
            return new SerialAccumulator(value);
        }
        return new ConcurrentAccumulator(value);
    }

    private static class ConcurrentAccumulator
    implements Accumulator {
        private AtomicInteger value;

        public ConcurrentAccumulator(int v) {
            this.value = new AtomicInteger(v);
        }

        @Override
        public final void add(int delta) {
            this.add(delta, (byte)-1);
        }

        @Override
        public void add(final int delta, byte flags) {
            Iteration it;
            if (GaloisRuntime.needMethodFlag(flags, (byte)2) && (it = Iteration.getCurrentIteration()) != null) {
                GaloisRuntime.getRuntime().onUndo(it, new Callback(){

                    @Override
                    public void call() {
                        value.addAndGet(-delta);
                    }
                });
            }
            this.value.addAndGet(delta);
        }

        @Override
        public int get() {
            assert (GaloisRuntime.getRuntime().inRoot());
            return this.value.get();
        }

        @Override
        public void set(int v) {
            assert (GaloisRuntime.getRuntime().inRoot());
            this.value.set(v);
        }

        @Override
        public void access(byte flags) {
        }
    }

    private static class SerialAccumulator
    implements Accumulator {
        private int value;

        public SerialAccumulator(int v) {
        }

        @Override
        public final void add(int delta) {
            this.add(delta, (byte)-1);
        }

        @Override
        public void add(int delta, byte flags) {
            this.value += delta;
        }

        @Override
        public int get() {
            return this.value;
        }

        @Override
        public void set(int v) {
            this.value = v;
        }

        @Override
        public void access(byte flags) {
        }
    }
}

