/*
 * Decompiled with CFR 0.152.
 */
package galois.objects;

import galois.objects.Counter;
import galois.runtime.AbstractExecutorContext;
import galois.runtime.Callback;
import galois.runtime.Features;
import galois.runtime.ForeachContext;
import galois.runtime.GaloisRuntime;
import galois.runtime.Iteration;
import galois.runtime.NonDeterministicCallback;
import galois.runtime.Replayable;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractCounter<T>
implements Counter<T>,
Replayable {
    protected final int countTo;
    private long rid;

    protected AbstractCounter(int countTo) {
        this.countTo = countTo;
        Features.getReplayFeature().onCreateReplayable(this);
        assert (this.getRid() != 0L);
    }

    protected abstract int counterAddAndGet(int var1);

    protected abstract void counterSet(int var1);

    protected abstract int counterGet();

    @Override
    public final void access(byte flags) {
    }

    @Override
    public final long getRid() {
        return this.rid;
    }

    @Override
    public final void setRid(long rid) {
        this.rid = rid;
    }

    @Override
    public final void increment(ForeachContext<T> ctx) {
        this.increment(ctx, (byte)-1);
    }

    @Override
    public final void increment(ForeachContext<T> ctx, byte flags) {
        this.increment(ctx, 1, flags);
    }

    @Override
    public final void increment(ForeachContext<T> ctx, int delta) {
        this.increment(ctx, delta, (byte)-1);
    }

    @Override
    public final void increment(int delta) {
        int value = this.counterAddAndGet(delta);
        if (value >= this.countTo) {
            throw new IllegalArgumentException("Serial Increment should not trigger callback");
        }
    }

    @Override
    public void reset() {
        this.counterSet(0);
    }

    protected abstract void body(ForeachContext<T> var1, int var2);

    @Override
    public final void increment(final ForeachContext<T> ctx, final int delta, byte flags) {
        if (GaloisRuntime.needMethodFlag(flags, (byte)2)) {
            GaloisRuntime.getRuntime().onCommit(Iteration.getCurrentIteration(), new Callback(){

                @Override
                public void call() {
                    AbstractCounter.this.body(ctx, delta);
                }
            });
        } else {
            this.body(ctx, delta);
        }
    }

    static abstract class AbstractConcurrentCounter<T>
    extends AbstractCounter<T> {
        private AtomicInteger counter = new AtomicInteger();

        protected AbstractConcurrentCounter(int countTo) {
            super(countTo);
            this.counter.set(0);
        }

        @Override
        protected final int counterAddAndGet(int delta) {
            return this.counter.addAndGet(delta);
        }

        @Override
        protected final void counterSet(int value) {
            this.counter.set(value);
        }

        @Override
        protected final int counterGet() {
            return this.counter.get();
        }
    }

    static abstract class AbstractSerialCounter<T>
    extends AbstractCounter<T> {
        private int counter;

        protected AbstractSerialCounter(int countTo) {
            super(countTo);
        }

        @Override
        protected final int counterAddAndGet(int delta) {
            this.counter += delta;
            return this.counter;
        }

        @Override
        protected final void counterSet(int value) {
            this.counter = value;
        }

        @Override
        protected final int counterGet() {
            return this.counter;
        }
    }

    protected abstract class OnlyAddCallback
    extends AbstractExecutorContext<T>
    implements NonDeterministicCallback {
        private ForeachContext<T> ctx;

        public OnlyAddCallback(ForeachContext<T> ctx) {
            this.ctx = ctx;
        }

        @Override
        public final void add(T item) {
            this.ctx.add(item, (byte)0);
        }

        @Override
        public abstract void call();

        @Override
        public final long getRid() {
            return AbstractCounter.this.rid;
        }

        @Override
        public final void setRid(long r) {
            AbstractCounter.this.rid = r;
        }
    }
}

